package com.upyuns.platform.rs.website.controller;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.NewsInfoBiz;
import com.upyuns.platform.rs.website.dto.NewsInfoDto;
import com.upyuns.platform.rs.website.entity.NewsInfo;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("newsInfo")
public class NewsInfoController extends BaseController<NewsInfoBiz, NewsInfo> {

	@PostMapping(value = "addUpdate")
	public ObjectRestResponse addUpdate(@RequestBody NewsInfo newsInfo) {
		return baseBiz.add(newsInfo);
	}

	@GetMapping(value = "getList")
	public ObjectRestResponse getList(NewsInfoDto newsInfoDto) {
		return baseBiz.selectList(newsInfoDto);
	}

	@GetMapping(value = "/app/unauth/getAll")
	public ObjectRestResponse getAll(NewsInfoDto newsInfoDto) {
		return baseBiz.selectList(newsInfoDto);
	}

	@GetMapping(value = "/app/unauth/getHot")
	public ObjectRestResponse getHotMsg() {
		return baseBiz.getHotMsg();
	}

	@GetMapping(value = "/app/unauth/detail")
	public ObjectRestResponse detail(Integer id) {
		return ObjectRestResponse.succ(baseBiz.selectById(id));
	}
}