package com.upyuns.platform.rs.website.controller;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.ImageInformationBiz;
import com.upyuns.platform.rs.website.dto.ImageInformationDto;
import com.upyuns.platform.rs.website.dto.UserAddressDto;
import com.upyuns.platform.rs.website.entity.ImageInformation;
import com.upyuns.platform.rs.website.entity.UserAddress;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("imageInformation")
public class ImageInformationController extends BaseController<ImageInformationBiz,ImageInformation> {

	@GetMapping(value = "getList")
	public ObjectRestResponse getList(ImageInformationDto imageInformationDto) {
		return baseBiz.selectList(imageInformationDto);
	}

	@PostMapping(value = "addUpdate")
	public ObjectRestResponse addUpdate(@RequestBody ImageInformation imageInformation) {
		return baseBiz.addUpdate(imageInformation);
	}

	@GetMapping(value = "/app/unauth/getAll")
	public ObjectRestResponse getAll(ImageInformationDto imageInformationDto) {
		return ObjectRestResponse.succ(baseBiz.selectList(imageInformationDto));
	}

}