package com.upyuns.platform.rs.website.controller;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.ImageImgStorageBiz;
import com.upyuns.platform.rs.website.dto.ImageInformationDto;
import com.upyuns.platform.rs.website.dto.ImageInformationStorageDto;
import com.upyuns.platform.rs.website.entity.ImageImgStorage;
import com.upyuns.platform.rs.website.entity.ImageInformation;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("imageImgStorage")
public class ImageImgStorageController extends BaseController<ImageImgStorageBiz,ImageImgStorage> {

	@GetMapping(value = "getList")
	public ObjectRestResponse getList(ImageInformationStorageDto imageInformationStorageDto) {
		return baseBiz.selectList(imageInformationStorageDto);
	}

	@PostMapping(value = "addUpdate")
	public ObjectRestResponse addUpdate(@RequestBody ImageImgStorage imageImgStorage) {
		return baseBiz.addUpdate(imageImgStorage);
	}

	@GetMapping(value = "/getDetail/{id}")
	public ObjectRestResponse getDetail(@PathVariable Integer id) {
		return baseBiz.getDetail(id);
	}
}