package com.upyuns.platform.rs.website.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.OrderUtil;
import com.upyuns.platform.rs.website.dto.UserOrderDto;
import com.upyuns.platform.rs.website.entity.OrderItem;
import com.upyuns.platform.rs.website.entity.ShoppingCartInfo;
import com.upyuns.platform.rs.website.mapper.OrderItemMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.upyuns.platform.rs.website.entity.OrderInfo;
import com.upyuns.platform.rs.website.mapper.OrderInfoMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import tk.mybatis.mapper.entity.Example;

import java.util.ArrayList;
import java.util.List;

/**
 * 订单信息
 *
 * @author jiaoruizhen
 * @email jiaoruizhen@126.com
 * @date 2020-12-03 13:29:23
 */
@Service
public class OrderInfoBiz extends BaseBiz<OrderInfoMapper, OrderInfo> {

	@Autowired
	OrderItemMapper orderItemMapper;

	/**
	 * 添加订单
	 * @param orderInfo
	 * @return
	 */
	public ObjectRestResponse addUpdate(OrderInfo orderInfo) {
		if (orderInfo == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		if (orderInfo.getOrderId() == null) {
			insertSelectiveRe(orderInfo);
		} else {
			OrderInfo old = selectById(orderInfo.getOrderId());
			BeanUtil.copyProperties(orderInfo, old, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
			updateSelectiveByIdRe(old);
		}
		return ObjectRestResponse.succ();
	}

	/**
	 * 下单
	 * @param orderInfo
	 * @return
	 */
	public ObjectRestResponse generateOrder(OrderInfo orderInfo) {
		if (orderInfo == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		if (StringUtils.isNotBlank(orderInfo.getOrderNo())) {
			orderInfo.setOrderNo(OrderUtil.GetOrderNumber("", OrderUtil.APP_MID));
		}
		OrderInfo old = getOneByOrderNo(orderInfo.getOrderNo());
		while (old != null) {
			orderInfo.setOrderNo(OrderUtil.GetOrderNumber("", OrderUtil.APP_MID));
			old = getOneByOrderNo(orderInfo.getOrderNo());
		}
		return addUpdate(orderInfo);
	}

	/**
	 * 根据订单号查询订单信息
	 * @param orderNo
	 * @return
	 */
	public OrderInfo getOneByOrderNo(String orderNo) {
		Example example = new Example(OrderInfo.class);
		example.createCriteria().andEqualTo("orderNo", orderNo).andNotEqualTo("status", -1).andEqualTo("status", -2);
		return mapper.selectOneByExample(example);
	}

	/**
	 * 查询用户所有订单
	 * @param userOrderDto
	 * @return
	 */
	public List<OrderInfo> getUserOrder(UserOrderDto userOrderDto) {
		Example example = new Example(OrderInfo.class);
		Example orderItemExample = new Example(OrderItem.class);
		Example.Criteria orderInfoCriteria = example.createCriteria();
		Example.Criteria orderItemCriteria = orderItemExample.createCriteria();
		if (userOrderDto.getStatus() != null) {
			orderInfoCriteria.andEqualTo("status", userOrderDto.getStatus());
		}
		if (userOrderDto.getPayStatus() != null) {
			orderInfoCriteria.andEqualTo("payStatus", userOrderDto.getPayStatus());
		}
		if (userOrderDto.getUserId() != null) {
			orderInfoCriteria.andEqualTo("userId", userOrderDto.getUserId());
		}
		if (StringUtils.isNotBlank(userOrderDto.getName())) {
			orderItemCriteria.andLike("name", "%"+ userOrderDto.getName() +"%");
		}

		orderInfoCriteria.andNotEqualTo("status", -1);
		example.orderBy("updTime").desc();
		List<OrderInfo> orderInfoList = mapper.selectByExample(example);
		if (orderInfoList != null) {

		}

		return new ArrayList<>();
	}


}