package com.upyuns.platform.rs.website.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import org.springframework.stereotype.Service;

import com.upyuns.platform.rs.website.entity.OrderEInvoice;
import com.upyuns.platform.rs.website.mapper.OrderEInvoiceMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

/**
 * 订单发票
 *
 * @author jiaoruizhen
 * @email jiaoruizhen@126.com
 * @date 2020-12-03 13:29:23
 */
@Service
public class OrderEInvoiceBiz extends BaseBiz<OrderEInvoiceMapper, OrderEInvoice> {

	/**
	 * 添加订单发票
	 * @param orderEInvoice
	 * @return
	 */
	public ObjectRestResponse addUpdate(OrderEInvoice orderEInvoice) {
		if (orderEInvoice == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		if (orderEInvoice.getId() == null) {
			insertSelectiveRe(orderEInvoice);
		} else {
			OrderEInvoice old = selectById(orderEInvoice.getId());
			BeanUtil.copyProperties(orderEInvoice, old, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
			updateSelectiveByIdRe(old);
		}
		return ObjectRestResponse.succ();
	}

	/**
	 * 查询用户所有订单发票
	 * @param userId
	 * @return
	 */
	public List<OrderEInvoice> getUserInvoice(Integer userId) {
		Example example = new Example(OrderEInvoice.class);
		example.createCriteria().andEqualTo("userId", userId);
		return mapper.selectByExample(example);
	}

}