package com.upyuns.platform.rs.website.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.website.dto.BannerDto;
import com.upyuns.platform.rs.website.entity.Banner;
import com.upyuns.platform.rs.website.mapper.BannerMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

/**
 * 轮播图
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2020-11-23 13:52:29
 */
@Service
public class BannerBiz extends BaseBiz<BannerMapper, Banner> {

	public ObjectRestResponse add(Banner banner) {
		if (banner == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		if (banner.getId() != null) {
			Banner old = selectById(banner.getId());
			if (old == null) {
				return ObjectRestResponse.createFailedResult(ResultCode.NOTEXIST_CODE, ResultCode.getMsg(ResultCode.NOTEXIST_CODE));
			}
			BeanUtil.copyProperties(banner, old, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
			updateSelectiveByIdRe(old);
		} else {
			insertSelectiveRe(banner);
		}
		return ObjectRestResponse.succ();
	}

	/**
	 * 查询所有展示的banner信息
	 * @param indexShow 是否首页展示
	 * @return
	 */
	public ObjectRestResponse<List<Banner>> getAll(Integer indexShow) {
		Example example = new Example(Banner.class);
		if (indexShow != null) {
			example.createCriteria().andEqualTo("isDel", 0).andEqualTo("status", 1).andEqualTo("indexShow",indexShow);
		} else {
			example.createCriteria().andEqualTo("isDel", 0).andEqualTo("status", 1);
		}
		example.orderBy("rank");
		return ObjectRestResponse.succ(mapper.selectByExample(example));
	}


	/**
	 * 后台分页查询
	 * @param bannerDto
	 * @return
	 */
	public ObjectRestResponse<PageDataVO<Banner>> selectList(BannerDto bannerDto) {
		Example example = new Example(Banner.class);
		Example.Criteria criteria = example.createCriteria();
		criteria.andEqualTo("isDel", 0);
		if (bannerDto.getStatus() != null) {
			criteria.andEqualTo("status", bannerDto.getStatus());
		}
		if (StringUtils.isNotBlank(bannerDto.getTitle())) {
			criteria.andLike("title", "%" + bannerDto.getTitle() + "%");
		}
		example.orderBy("rank");
		Query query = new Query(bannerDto);
		PageDataVO<Banner> pageDataVO = PageDataVO.pageInfo(query, () -> mapper.selectByExample(example));
		return ObjectRestResponse.succ(pageDataVO);
	}

}