package com.upyuns.platform.rs.website.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 行业应用信息
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2020-11-23 13:52:29
 */
@Data
@Table(name = "industry_application_info")
public class IndustryApplicationInfo implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 *
	 */
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty("")
	private Integer id;

	/**
	 * 标题
	 */
	@Column(name = "title")
	@ApiModelProperty(value = "标题")
	private String title;

	/**
	 * 封面图
	 */
	@Column(name = "cover_img")
	@ApiModelProperty(value = "封面图")
	private String coverImg;

	/**
	 * 详情图
	 */
	@Column(name = "detail_img")
	@ApiModelProperty(value = "详情图")
	private String detailImg;

	/**
	 * 详细描述
	 */
	@Column(name = "introduction")
	@ApiModelProperty(value = "详细描述")
	private String introduction;

	/**
	 * 属性值json{"industry":"行业","area":"区域","achievements":"成果","source":"数据来源","date":"采集时间","ratio":"分辨率"}
	 */
	@Column(name = "attribute")
	private String attribute;

	/**
	 * 是否提供样例：0、不提供，1、提供
	 */
	@Column(name = "examples")
	@ApiModelProperty(value = "是否提供样例：0、不提供，1、提供")
	private Integer examples;

	/**
	 * 样例json:[{"filename":"文件名","size":"文件大小","url":"文件路径"}]
	 */
	@Column(name = "examples_json")
	private String examplesJson;

	/**
	 * 交易保障
	 */
	@Column(name = "protection")
	@ApiModelProperty(value = "交易保障")
	private String protection;

	/**
	 * 是否删除：0、否， 1、是
	 */
	@Column(name = "is_del")
	@ApiModelProperty(value = "是否删除：0、否， 1、是")
	private Integer isDel;

	/**
	 * 排序
	 */
	@Column(name = "rank")
	@ApiModelProperty(value = "排序")
	private Integer rank;

	/**
	 * 是否启用：1、启用，2、禁用
	 */
	@Column(name = "status")
	@ApiModelProperty(value = "是否启用：1、启用，2、禁用")
	private Integer status;

	/**
	 * 行业应用类型id
	 */
	@Column(name = "first_type_id")
	@ApiModelProperty(value = "资讯类型")
	private Integer firstTypeId;

	/**
	 *
	 */
	@Column(name = "second_type_id")
	@ApiModelProperty(value = "")
	private Integer secondTypeId;

	/**
	 * 是否首页展示：1、展示，2、不展示
	 */
	@Column(name = "index_show")
	@ApiModelProperty(value = "是否首页展示：1、展示，2、不展示")
	private Integer indexShow;

	/**
	 *  创建时间
	 */
	@Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
	private Date crtTime;

	/**
	 *  修改时间
	 */
	@Column(name = "upd_time")
	@ApiModelProperty(value = "修改时间", hidden = true )
	private Date updTime;

	/**
	 * 是否提供定制：1、提供，2、不提供
	 */
	private Integer customized;

	@Transient
	private String firstTitle;

	@Transient
	private String secondTitle;

}
