package com.upyuns.platform.rs.website.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 通用信息
 * 
 * @author jiaoruizhen
 * @email jiaoruizhen@126.com
 * @date 2020-11-24 14:37:58
 */
@Data
@Table(name = "common_info")
public class CommonInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  
   */
    @Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty("")
    private Integer id;
	
	    /**
     *  1、交易保障
     */
    @Column(name = "type")
	@ApiModelProperty(value = "1、交易保障")
    private Integer type;
	
	    /**
     *  标题
     */
    @Column(name = "title")
	@ApiModelProperty(value = "标题")
    private String title;
	
	    /**
     *  内容
     */
    @Column(name = "detail")
	@ApiModelProperty(value = "内容")
    private String detail;
	
	    /**
     *  1、启用，2、禁用
     */
    @Column(name = "status")
	@ApiModelProperty(value = "1、启用，2、禁用")
    private Integer status;
	
	    /**
     *  是否删除:0、否，1、是
     */
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除:0、否，1、是")
    private Integer isDel;
	
	    /**
     *  标题背景色，16进制
     */
    @Column(name = "color")
	@ApiModelProperty(value = "标题背景色，16进制")
    private String color;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Date crtTime;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Date updTime;
	
	    /**
     *  排序
     */
    @Column(name = "rank")
	@ApiModelProperty(value = "排序")
    private Integer rank;
	

}
