package com.upyuns.platform.rs.universal.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.context.BaseContextHandler;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.upyuns.platform.rs.universal.entity.MemberFamilyInfo;
import com.upyuns.platform.rs.universal.entity.MemberInfo;
import com.upyuns.platform.rs.universal.mapper.MemberFamilyInfoMapper;
import com.upyuns.platform.rs.universal.mapper.MemberInfoMapper;
import com.upyuns.platform.rs.universal.vo.MemberFamilyInfoVo;
import com.upyuns.platform.rs.universal.vo.MemberInfoVo;
import org.springframework.beans.BeanUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

//@Service
//@Transactional
public class MemberInfoService extends BaseBiz<MemberInfoMapper, MemberInfo> {

    //@Autowired
    MemberFamilyInfoMapper memberFamilyInfoMapper;

    public void insert(MemberInfoVo memberInfoVo) {
        MemberInfo memberInfo = new MemberInfo();
        BeanUtils.copyProperties(memberInfoVo, memberInfo);
        if (null == memberInfo.getCreateDate()) {
            memberInfo.setCreateDate(new Date());
        }
        memberInfo.setState((byte) 0);

        memberInfo.setCreateUserId(Integer.valueOf(BaseContextHandler.getUserID()));
        memberInfo.setCreateUserName(BaseContextHandler.getName());

        super.insert(memberInfo);

        List<MemberFamilyInfoVo> family = memberInfoVo.getFamily();
        if (null != family && family.size() > 0) {
            List<MemberFamilyInfo> familyInfos = new ArrayList<>();
            for (MemberFamilyInfoVo info : family) {
                MemberFamilyInfo familyInfo = new MemberFamilyInfo();
                BeanUtils.copyProperties(info, familyInfo);
                familyInfo.setMemberId(memberInfo.getId());
                familyInfos.add(familyInfo);
            }
            memberFamilyInfoMapper.insertList(familyInfos);
        }
    }

    public void deleteById(Integer id) {
        super.deleteById(id);
        memberFamilyInfoMapper.deleteByMemberId(id);
    }

    public MemberInfoVo selectById(Integer id) {

        MemberInfo info = super.selectById(id);

        if (null == info) {
            throw new BaseException("用户不存在");
        }

        MemberInfoVo result = new MemberInfoVo();
        BeanUtils.copyProperties(info, result);

        List<MemberFamilyInfo> family = memberFamilyInfoMapper.selectByMemberId(id);

        List<MemberFamilyInfoVo> familyInfoVos = new ArrayList<>();

        for (MemberFamilyInfo familyInfo : family) {
            MemberFamilyInfoVo familyInfoVo = new MemberFamilyInfoVo();
            BeanUtils.copyProperties(familyInfo, familyInfoVo);
            familyInfoVos.add(familyInfoVo);
        }

        result.setFamily(familyInfoVos);

        return result;
    }


    public PageInfo<MemberInfoVo> selectAll(String name, Integer pageNum, Integer pageSize) {
        PageHelper.startPage(pageNum, pageSize);
        if (name != null) {
            name = name.trim();
            if (name.length() > 0) {
                return new PageInfo<>(mapper.selectVoByName(name.trim()));
            }
        }
        return new PageInfo<>(mapper.selectVoAll());
    }


    public void updateSelectiveById(MemberInfoVo memberInfoVo) {
        MemberInfo memberInfo = new MemberInfo();
        BeanUtils.copyProperties(memberInfoVo, memberInfo);
        super.updateSelectiveById(memberInfo);
        List<MemberFamilyInfoVo> family = memberInfoVo.getFamily();

        if (null != family && family.size() > 0) {
            List<Integer> ids = new ArrayList<>();
            for (MemberFamilyInfoVo memberFamilyInfoVo : family) {
                MemberFamilyInfo info = new MemberFamilyInfo();
                BeanUtils.copyProperties(memberFamilyInfoVo, info);
                info.setMemberId(memberInfoVo.getId());
                if (null == info.getId()) {
                    memberFamilyInfoMapper.insert(info);
                } else {
                    memberFamilyInfoMapper.updateByPrimaryKeySelective(info);
                }
                ids.add(info.getId());
            }
            memberFamilyInfoMapper.deleteByMemberIdNotInIds(memberInfoVo.getId(), ids);
        } else {
            memberFamilyInfoMapper.deleteByMemberId(memberInfoVo.getId());
        }
    }

}
