package com.upyuns.platform.rs.universal.controller;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.upyuns.platform.rs.universal.biz.MQServiceBiZ;
import com.upyuns.platform.rs.universal.dto.SendMsgDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping(value = "message")
public class MQSenderController {

    @Autowired
    private MQServiceBiZ mqServiceBiZ;

    @GetMapping(value = "/sendMessage")
    public ObjectRestResponse sendMessage(String exchange, String routKey, String json) {
        return mqServiceBiZ.sendMessage(exchange, routKey, json);
    }

    @PostMapping(value = "/app/unauth/sendMessage")
    public ObjectRestResponse sendPostMessage(@RequestBody String json) {
        return mqServiceBiZ.sendMessage("","", json);
    }

    @PostMapping(value = "/sendMessage")
    @ResponseBody
    public ObjectRestResponse sendMessage(@RequestBody SendMsgDTO dto) {
        return mqServiceBiZ.sendMessage(dto.getExchange(), dto.getRoutKey(), dto.getJson());
    }


}
