package com.upyuns.platform.rs.datacenter.rest;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.UserAgentUtil;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.util.result.JsonResultUtil;
import com.github.wxiaoqi.security.common.vo.PageParam;
import com.upyuns.platform.rs.datacenter.biz.RscpAreaImageTotalBiz;
import com.upyuns.platform.rs.datacenter.biz.RscpImageDataTotalBiz;
import com.upyuns.platform.rs.datacenter.entity.RscpImageDataTotal;
import io.swagger.annotations.ApiOperation;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import sun.nio.cs.ext.Big5;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

@RestController
@RequestMapping("imageData")
public class RscpImageDataTotalController extends BaseController<RscpImageDataTotalBiz, RscpImageDataTotal> {

    @Autowired
    RscpAreaImageTotalBiz rscpAreaImageTotalBiz;

    @RequestMapping(value = "/app/unauth/query", method = RequestMethod.GET)
    public ObjectRestResponse unauthQuery(PageParam pageParam) {
        return ObjectRestResponse.succ(baseBiz.selectByQuery(new Query(pageParam)));
    }

//   resolution
//	     分辨率
//	 spectrum
//	     光谱
//	 startDate
//	     2017/04/14
//     endDate
//	     2017/07/13
//     geom
//	     {"type":"Polygon","coordinates":[[[3,4],[3,2],[1,2],[1,4],[3,4]]]}
//	 areaNo
//	     行政区域
//	 areaName
//	     行政区域名称
//	 resolutionSa
//	     分辨率/卫星
//	 saSensor
//	     卫星/传感器 {'GF2':'[PMS]','GF4':'[IRS]','GF1':'[PMS]'}
//	 shp
//	     2
//     cloud
//	     云量 10
//     imageSatelliteType
//	     卫星
//	 request
//	 resId
//	     分辨率id

    @RequestMapping(value = "/app/unauth/queryDataList", method = RequestMethod.POST)
    public ObjectRestResponse queryDataList(@RequestBody QueryDTO dto) {
        if(RscpImageDataTotalController.QueryDTO.TYPE_AREA == dto.getType()) {
            return ObjectRestResponse.succ(rscpAreaImageTotalBiz.queryDataList(dto));
        }else {
            return ObjectRestResponse.succ(baseBiz.queryDataList(dto));
        }
    }


    @Data
    static public class QueryDTO {
        public static final int TYPE_AREA = 1;
        public static final int TYPE_GEOM = 2;
        Integer type;
	    String startDate;
        String endDate;
        String startDateTime;
        String endDateTime;
        String geom;
        Double leftLon;
        Double rightLon;
        Double topLat;
        Double bottomLat;
        String areaNo;
        String provinceNo;
        List<satelliteDTO> saSensor;
        BigDecimal cloud;

        public void setStartDate(String startDate) {
            this.startDate = startDate;
            this.startDateTime = DateUtil.beginOfDay(DateUtil.parseDate(startDate)).toString();
        }

        public void setEndDate(String endDate) {
            this.endDate = endDate;
            this.endDateTime = DateUtil.endOfDay(DateUtil.parseDate(endDate)).toString();
        }

        public void setAreaNo(String areaNo) {
            this.areaNo = areaNo;
            if(StrUtil.isNotBlank(areaNo)) {
                if(!areaNo.substring(2, 6).equals("0000")){
                    provinceNo = areaNo.substring(0, 2);
                }
            }
        }
    }

    @Data
    static public class satelliteDTO {
        String satellite;
        List<String> sensors = CollUtil.newArrayList();
    }
}