package com.upyuns.platform.rs.website.controller;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.NewsTypeBiz;
import com.upyuns.platform.rs.website.dto.NewsTypeDto;
import com.upyuns.platform.rs.website.entity.NewsType;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("newsType")
public class NewsTypeController extends BaseController<NewsTypeBiz, NewsType> {

	@PostMapping(value = "addUpdate")
	public ObjectRestResponse addOrUpdate(@RequestBody NewsType newsType) {
		return baseBiz.add(newsType);
	}

	@GetMapping(value = "getAll")
	public ObjectRestResponse getAll(Integer indexShow) {
		return baseBiz.getAll(indexShow);
	}

	@GetMapping(value = "getList")
	public ObjectRestResponse getList(NewsTypeDto newsTypeDto) {
		return baseBiz.selectList(newsTypeDto);
	}

}