package com.upyuns.platform.rs.website.controller;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.IndustryApplicationTypeBiz;
import com.upyuns.platform.rs.website.dto.IndustryApplicationTypeDto;
import com.upyuns.platform.rs.website.entity.IndustryApplicationType;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("industryApplicationType")
public class IndustryApplicationTypeController extends BaseController<IndustryApplicationTypeBiz, IndustryApplicationType> {

	@PostMapping(value = "addUpdate")
	public ObjectRestResponse addUpdate(@RequestBody IndustryApplicationType industryApplicationType) {
		return baseBiz.add(industryApplicationType);
	}

	@GetMapping(value = "getList")
	public ObjectRestResponse getList(IndustryApplicationTypeDto industryApplicationTypeDto) {
		return baseBiz.selectList(industryApplicationTypeDto);
	}

	@GetMapping(value = "getAll")
	public ObjectRestResponse getAll(Integer indexShow) {
		return baseBiz.getAll(indexShow);
	}


}