package com.upyuns.platform.rs.website.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.map.MapUtil;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.website.dto.NewsInfoDto;
import com.upyuns.platform.rs.website.entity.NewsInfo;
import com.upyuns.platform.rs.website.entity.NewsType;
import com.upyuns.platform.rs.website.mapper.NewsInfoMapper;
import com.upyuns.platform.rs.website.vo.NewsInfoTypeVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import tk.mybatis.mapper.entity.Example;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 新闻咨询
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2020-11-23 13:52:28
 */
@Service
public class NewsInfoBiz extends BaseBiz<NewsInfoMapper, NewsInfo> {

	@Autowired
	NewsTypeBiz newsTypeBiz;

	/**
	 * 新增咨询
	 * @param newsInfo
	 * @return
	 */
	public ObjectRestResponse add(NewsInfo newsInfo) {
		if (newsInfo == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		if (newsInfo.getId() != null) {
			NewsInfo old = selectById(newsInfo.getId());
			if (old == null) {
				return ObjectRestResponse.createFailedResult(ResultCode.NOTEXIST_CODE, ResultCode.getMsg(ResultCode.NOTEXIST_CODE));
			}
			BeanUtil.copyProperties(newsInfo, old, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
			updateSelectiveByIdRe(old);
		} else {
			insertSelectiveRe(newsInfo);
		}
		return ObjectRestResponse.succ();
	}

	/**
	 * 查看详情
	 * @param id
	 * @return
	 */
	public ObjectRestResponse<NewsInfo> getOneById(Integer id) {
		NewsInfo old = selectById(id);
		if (old == null || old.getIsDel() == 1) {
			return ObjectRestResponse.createFailedResult(ResultCode.NOTEXIST_CODE, ResultCode.getMsg(ResultCode.NOTEXIST_CODE));
		}
		return ObjectRestResponse.succ(old);
	}


	/**
	 * 查询所有首页展示数据
	 * @return
	 */
	public ObjectRestResponse<List<NewsInfoTypeVo>> getAll() {
		Example example = new Example(NewsInfo.class);
		example.createCriteria().andEqualTo("isDel", 0).andEqualTo("status", 1).andEqualTo("indexShow", 1);
		List<NewsInfoTypeVo> newsInfoTypeVoList = new ArrayList<>();
		List<NewsInfo> list = mapper.selectByExample(example);
		if (list != null && list.size() > 0) {
			Map<Integer, List<NewsInfo>> listMap = list.stream()
					.collect(Collectors.groupingBy(NewsInfo::getTypeId));
			if (MapUtil.isNotEmpty(listMap)) {
				List<NewsType> newsTypeList = newsTypeBiz.getAll(1).getData();
				if (newsTypeList != null && newsTypeList.size() > 0) {
					Map<Integer, List<NewsType>> map = newsTypeList.stream().collect(Collectors.groupingBy(NewsType::getId));
					for (Map.Entry<Integer, List<NewsInfo>> entry : listMap.entrySet()) {
						List<NewsType> newsTypes = map.get(entry.getKey());
						if (newsTypes != null && newsTypes.size() > 0) {
							NewsInfoTypeVo newsInfoTypeVo = new NewsInfoTypeVo();
							BeanUtils.copyProperties(newsTypes.get(0), newsInfoTypeVo);
							if (entry.getValue() != null && entry.getValue().size() > 0) {
								newsInfoTypeVo.setNewsInfoList(entry.getValue().get(0));
							}
							newsInfoTypeVoList.add(newsInfoTypeVo);
						}
					}
				}
			}
		}
		List<NewsInfoTypeVo> newsInfoTypeVos = newsInfoTypeVoList.stream().sorted((u1, u2) -> u1.getRank().compareTo(u2.getRank())).collect(Collectors.toList());
		return ObjectRestResponse.succ(newsInfoTypeVos);
	}


	/**
	 * 后台查询列表信息
	 * @param newsInfoDto
	 * @return
	 */
	public ObjectRestResponse<PageDataVO<NewsInfo>> selectList(NewsInfoDto newsInfoDto) {
		Query query = new Query(newsInfoDto);
		PageDataVO<NewsInfo> pageDataVO = PageDataVO.pageInfo(query, () -> mapper.selectList(query.getSuper()));
		return ObjectRestResponse.succ(pageDataVO);
	}

}