package com.upyuns.platform.rs.website.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.website.dto.IndustryApplicationTypeDto;
import com.upyuns.platform.rs.website.dto.NewsTypeDto;
import com.upyuns.platform.rs.website.entity.IndustryApplicationType;
import com.upyuns.platform.rs.website.entity.NewsType;
import com.upyuns.platform.rs.website.mapper.IndustryApplicationTypeMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

/**
 * 行业应用类型
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2020-11-23 13:52:29
 */
@Service
public class IndustryApplicationTypeBiz extends BaseBiz<IndustryApplicationTypeMapper, IndustryApplicationType> {


	/**
	 * 新增类型
	 * @param industryApplicationType
	 * @return
	 */
	public ObjectRestResponse add(IndustryApplicationType industryApplicationType) {
		if (industryApplicationType == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		if (industryApplicationType.getId() != null) {
			IndustryApplicationType old = selectById(industryApplicationType.getId());
			if (old == null) {
				return ObjectRestResponse.createFailedResult(ResultCode.NOTEXIST_CODE, ResultCode.getMsg(ResultCode.NOTEXIST_CODE));
			}
			if (StringUtils.isNotBlank(industryApplicationType.getTitle())) {
				IndustryApplicationType nameValue = getOneByTitle(industryApplicationType.getTitle());
				if (nameValue != null) {
					return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE, "行业应用类型已存在！");
				}
			}
			BeanUtil.copyProperties(industryApplicationType, old, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
			updateSelectiveByIdRe(old);
		} else {
			insertSelectiveRe(industryApplicationType);
		}
		return ObjectRestResponse.succ();
	}


	public IndustryApplicationType getOneByTitle(String title) {
		Example example = new Example(IndustryApplicationType.class);
		example.createCriteria().andEqualTo("title", title);
		return mapper.selectOneByExample(example);
	}

	/**
	 * 查询所有首页展示
	 * @param indexShow 是否首页展示
	 * @return
	 */
	public ObjectRestResponse<List<IndustryApplicationType>> getAll(Integer indexShow) {
		Example example = new Example(IndustryApplicationType.class);
		if (indexShow != null) {
			example.createCriteria().andEqualTo("isDel", 0).andEqualTo("status", 1).andEqualTo("indexShow",indexShow);
		} else {
			example.createCriteria().andEqualTo("isDel", 0).andEqualTo("status", 1);
		}
		example.orderBy("rank");
		return ObjectRestResponse.succ(mapper.selectByExample(example));
	}


	/**
	 * 行业应用类型
	 * @param industryApplicationTypeDto
	 * @return
	 */
	public ObjectRestResponse<PageDataVO<IndustryApplicationType>> selectList(IndustryApplicationTypeDto industryApplicationTypeDto) {
		Example example = new Example(IndustryApplicationType.class);
		Example.Criteria criteria = example.createCriteria();
		criteria.andEqualTo("isDel", 0);
		if (StringUtils.isNotBlank(industryApplicationTypeDto.getTitle())) {
			criteria.andLike("title", "%" + industryApplicationTypeDto.getTitle() + "%");
		}
		example.orderBy("updTime").desc();
		Query query = new Query(industryApplicationTypeDto);
		PageDataVO<IndustryApplicationType> pageDataVO = PageDataVO.pageInfo(query, () -> mapper.selectByExample(example));
		return ObjectRestResponse.succ(pageDataVO);
	}

}