package com.upyuns.platform.rs.website.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 新闻咨询
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2020-11-23 13:52:28
 */
@Data
@Table(name = "news_info")
public class NewsInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  
   */
    @Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty("")
    private Integer id;
	
	    /**
     *  标题
     */
    @Column(name = "title")
	@ApiModelProperty(value = "标题")
    private String title;
	
	    /**
     *  简介
     */
    @Column(name = "detail")
	@ApiModelProperty(value = "简介")
    private String detail;
	
	    /**
     *  封面图
     */
    @Column(name = "cover_img")
	@ApiModelProperty(value = "封面图")
    private String coverImg;
	
	    /**
     *  内容
     */
    @Column(name = "content")
	@ApiModelProperty(value = "内容")
    private String content;
	
	    /**
     *  新闻日期
     */
    @Column(name = "news_date")
	@ApiModelProperty(value = "新闻日期")
    private Date newsDate;
	
	    /**
     *  资讯类型
     */
    @Column(name = "type_id")
	@ApiModelProperty(value = "资讯类型")
    private Integer typeId;
	
	    /**
     *  是否删除：0、否，1、是
     */
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除：0、否，1、是")
    private Integer isDel;
	
	    /**
     *  是否启用:1、启用，2、禁用
     */
    @Column(name = "status")
	@ApiModelProperty(value = "是否启用:1、启用，2、禁用")
    private Integer status;
	
	    /**
     *  
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "", hidden = true )
    private Date crtTime;
	
	    /**
     *  
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "", hidden = true )
    private Date updTime;
	
	    /**
     *  是否首页展示：1、展示，2、不展示
     */
    @Column(name = "index_show")
	@ApiModelProperty(value = "是否首页展示：1、展示，2、不展示")
    private Integer indexShow;
	

    @Transient
	String typeName;

}
