package com.upyuns.platform.rs.website.controller.web;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.UserAddressBiz;
import com.upyuns.platform.rs.website.dto.UserAddressDto;
import com.upyuns.platform.rs.website.entity.UserAddress;
import com.upyuns.platform.rs.website.entity.UserInvoice;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("userAddress/web")
public class UserAddressWebController extends BaseController<UserAddressBiz,UserAddress>{

	@PostMapping(value = "addUpdate")
	public ObjectRestResponse addUpdate(@RequestBody UserAddress userAddress) {
		return baseBiz.addUpdate(userAddress);
	}

	@GetMapping(value = "getUserAddress")
	public ObjectRestResponse getUserAddress(UserAddressDto userAddressDto) {
		return baseBiz.getUserAddress(userAddressDto);
	}

	@PostMapping(value = "setDefault")
	public ObjectRestResponse setDefault(@RequestBody UserAddress userAddress) {
		return baseBiz.setDefault(userAddress.getId());
	}
}