package com.upyuns.platform.rs.website.controller.web;

import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.FeedbackInfoBiz;
import com.upyuns.platform.rs.website.dto.FeedbackInfoDto;
import com.upyuns.platform.rs.website.entity.FeedbackInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("feedbackInfo/web")
public class FeedbackInfoWebController extends BaseController<FeedbackInfoBiz,FeedbackInfo> implements UserRestInterface {

	@Autowired
	UserFeign userFeign;

	@PostMapping(value = "addObj")
	public ObjectRestResponse addObj(@RequestBody FeedbackInfo feedbackInfo) {
		return baseBiz.addObj(feedbackInfo);
	}


	@GetMapping(value = "getAll")
	public ObjectRestResponse getAll(FeedbackInfoDto feedbackInfoDto) {
		feedbackInfoDto.setUserId(Integer.parseInt(getCurrentUserId()));
		return baseBiz.getAll(feedbackInfoDto);
	}

	@Override
	public UserFeign getUserFeign() {
		return userFeign;
	}
}