package com.upyuns.platform.rs.website.controller;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.ApiDocBiz;
import com.upyuns.platform.rs.website.biz.BannerBiz;
import com.upyuns.platform.rs.website.dto.ApiDocDTO;
import com.upyuns.platform.rs.website.dto.TModelTypeDTO;
import com.upyuns.platform.rs.website.entity.ApiDoc;
import com.upyuns.platform.rs.website.entity.Banner;
import com.upyuns.platform.rs.website.entity.TModel;
import com.upyuns.platform.rs.website.entity.TModelType;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("apiDoc")
public class apiDocController extends BaseController<ApiDocBiz, ApiDoc> {

    @PostMapping(value = "/app/unauth/list")
    @IgnoreUserToken
    public ObjectRestResponse list(@RequestBody ApiDocDTO apiDocDTO) {
        return baseBiz.getList(apiDocDTO);
    }


    @PostMapping(value = "/addUpdate")
    public ObjectRestResponse addUpdate(@RequestBody ApiDoc apiDoc) {
        return baseBiz.addObj(apiDoc);
    }


    @PostMapping(value = "/getList")
    public ObjectRestResponse getList(@RequestBody ApiDocDTO apiDocDTO) {
        return baseBiz.getListV2(apiDocDTO);
    }


    @GetMapping(value = "/detail")
    public ObjectRestResponse detail(Integer id) {
        return ObjectRestResponse.succ(baseBiz.selectById(id));
    }

    @PostMapping(value = "/list")
    public ObjectRestResponse listV2(@RequestBody ApiDocDTO apiDocDTO) {
        return baseBiz.getList(apiDocDTO);
    }


}
