package com.upyuns.platform.rs.website.controller;


import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.ApiCustomNodeBiz;
import com.upyuns.platform.rs.website.biz.ApiDocBiz;
import com.upyuns.platform.rs.website.dto.ApiCustomNodeDTO;
import com.upyuns.platform.rs.website.dto.ApiDocDTO;
import com.upyuns.platform.rs.website.entity.ApiCustomNode;
import com.upyuns.platform.rs.website.entity.ApiDoc;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("apiCustomNode")
public class apiCustomNodeController extends BaseController<ApiCustomNodeBiz, ApiCustomNode> {


    /**
     * 根据文档id返回接口列表
     * @param id
     * @return
     */
    @GetMapping(value = "/app/unauth/{id}/list")
    @IgnoreUserToken
    public ObjectRestResponse getListByAPiDocId(@PathVariable Integer id) {
        return baseBiz.getListByAPiDocId(id);
    }

    /**
     * 接口详情
     * @param id
     * @return
     */
    @GetMapping(value = "/app/unauth/{id}")
    @IgnoreUserToken
    public ObjectRestResponse getListById(@PathVariable Integer id) {
        return baseBiz.getListById(id);
    }


    @PostMapping(value = "/addUpdate")
    public ObjectRestResponse addUpdate(@RequestBody ApiCustomNode apiCustomNode) {
        return baseBiz.addObj(apiCustomNode);
    }


    @PostMapping(value = "/getList")
    public ObjectRestResponse getList(@RequestBody ApiCustomNodeDTO apiCustomNodeDTO) {
        return baseBiz.getListV2(apiCustomNodeDTO);
    }


    @GetMapping(value = "/detail")
    public ObjectRestResponse detail(Integer id) {
        return baseBiz.getListById(id);
    }




}
