package com.upyuns.platform.rs.website.controller;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.ShoppingCartInfoBiz;
import com.upyuns.platform.rs.website.biz.TModelBiz;
import com.upyuns.platform.rs.website.dto.TModelDTO;
import com.upyuns.platform.rs.website.entity.IndustryApplicationInfo;
import com.upyuns.platform.rs.website.entity.ShoppingCartInfo;
import com.upyuns.platform.rs.website.entity.TModel;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("tModel")
public class TModelController extends BaseController<TModelBiz, TModel> {



    @PostMapping(value = "/app/unauth/addUpdate")
    @IgnoreUserToken
    public ObjectRestResponse addUpdate(@RequestBody TModel tModel) {
        return baseBiz.addObj(tModel);
    }


    @PostMapping(value = "/app/unauth/getList")
    @IgnoreUserToken
    public ObjectRestResponse getList(@RequestBody TModelDTO tModelDTO) {
        return baseBiz.getList(tModelDTO);
    }


    @GetMapping(value = "/app/unauth/detail")
    @IgnoreUserToken
    public ObjectRestResponse detail(Integer id) {
        return ObjectRestResponse.succ(baseBiz.selectById(id));
    }


    @PostMapping(value = "/addUpdate")
    public ObjectRestResponse addUpdateV2(@RequestBody TModel tModel) {
        return baseBiz.addObj(tModel);
    }


    @PostMapping(value = "/getList")
    public ObjectRestResponse getListV2(@RequestBody TModelDTO tModelDTO) {
        return baseBiz.getList(tModelDTO);
    }


    @GetMapping(value = "/detail")
    public ObjectRestResponse detailV2(Integer id) {
        return ObjectRestResponse.succ(baseBiz.selectById(id));
    }



//    @PostMapping(value = "delete/{id}")
//    public ObjectRestResponse remove(@PathVariable Integer id) {
//        return baseBiz.remove(id);
//    }

}
