package com.upyuns.platform.rs.website.controller;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.ImageImgStorageBiz;
import com.upyuns.platform.rs.website.dto.ImageInformationDto;
import com.upyuns.platform.rs.website.dto.ImageInformationStorageDto;
import com.upyuns.platform.rs.website.dto.ImageStorageImgDto;
import com.upyuns.platform.rs.website.entity.ImageImgStorage;
import com.upyuns.platform.rs.website.entity.ImageInformation;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("imageImgStorage")
public class ImageImgStorageController extends BaseController<ImageImgStorageBiz,ImageImgStorage> {


    @ApiModelProperty("最新图谱库信息列表")
    @GetMapping(value = "/app/unauth/mapAll")
    @IgnoreUserToken
    public ObjectRestResponse mapAll(ImageInformationStorageDto dto) {
        return baseBiz.mapAll(dto);
    }

    @ApiModelProperty("热度图谱库信息列表")
    @GetMapping(value = "/app/unauth/hotAll")
    @IgnoreUserToken
    public ObjectRestResponse all(ImageInformationStorageDto dto) {
        return baseBiz.all(dto);
    }





	@GetMapping(value = "getList")
	public ObjectRestResponse getList(ImageInformationStorageDto imageInformationStorageDto) {
		return baseBiz.selectList(imageInformationStorageDto, 1);
	}

	@PostMapping(value = "addUpdate")
	public ObjectRestResponse addUpdate(@RequestBody ImageImgStorage imageImgStorage) {
		if(null == imageImgStorage.getUptype()) {
			imageImgStorage.setUptype(ImageImgStorage.UPTYPE_UPLOAD);
		}
		return baseBiz.addUpdate(imageImgStorage);
	}

	@GetMapping(value = "/getDetail/{id}")
	public ObjectRestResponse getDetail(@PathVariable Integer id) {
		return baseBiz.getDetail(id);
	}


	@PostMapping(value = "updateStatus")
	public ObjectRestResponse updateStatus(@RequestBody ImageImgStorage imageImgStorage) {
		return baseBiz.updateStatus(imageImgStorage);
	}

	@PostMapping(value = "updateBatch")
	public ObjectRestResponse updateBatch(@RequestBody ImageStorageImgDto imageStorageImgDto) {
		return baseBiz.updateBatch(imageStorageImgDto);
	}
}