package com.upyuns.platform.rs.website.controller;


import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.ApiCustomNodeBiz;
import com.upyuns.platform.rs.website.biz.ApiCustomParamsBiz;
import com.upyuns.platform.rs.website.dto.ApiCustomNodeDTO;
import com.upyuns.platform.rs.website.dto.ApiCustomParamsDTO;
import com.upyuns.platform.rs.website.entity.ApiCustomNode;
import com.upyuns.platform.rs.website.entity.ApiCustomParams;
import com.upyuns.platform.rs.website.mapper.ApiCustomParamsMapper;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.*;

/**
 *
 */
@RestController
@RequestMapping("apiCustomParams")
public class ApiCustomParamsController extends BaseController<ApiCustomParamsBiz, ApiCustomParams> {



    @PostMapping(value = "/addUpdate")
    public ObjectRestResponse addUpdate(@RequestBody ApiCustomParams apiCustomParams) {
        return baseBiz.addObj(apiCustomParams);
    }


    @PostMapping(value = "/getList")
    public ObjectRestResponse getList(@RequestBody ApiCustomParamsDTO apiCustomParamsDTO) {
        return baseBiz.getListV2(apiCustomParamsDTO);
    }


    @GetMapping(value = "/detail")
    public ObjectRestResponse detail(Integer id) {
        return ObjectRestResponse.succ(baseBiz.selectById(id));
    }


}




