package com.upyuns.platform.rs.website.biz;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.website.dto.TModelDTO;
import com.upyuns.platform.rs.website.entity.IndustryApplicationInfo;
import com.upyuns.platform.rs.website.entity.TModel;
import com.upyuns.platform.rs.website.mapper.TModelMapper;
import org.springframework.stereotype.Service;
import com.github.wxiaoqi.security.common.util.Query;

import java.util.List;
import java.util.Objects;

/**
 *
 */
@Service
public class TModelBiz extends BaseBiz<TModelMapper, TModel>{

    public ObjectRestResponse addObj(TModel tModel) {
        if (tModel == null) {
            return ObjectRestResponse.paramIsEmpty();
        }
        if (tModel.getId() != null) {
            TModel old = selectById(tModel.getId());
            if (old == null || old.getIsDel() == 1) {
                return ObjectRestResponse.createFailedResult(ResultCode.NOTEXIST_CODE, ResultCode.getMsg(ResultCode.NOTEXIST_CODE));
            }
            BeanUtil.copyProperties(tModel, old, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
            updateSelectiveByIdRe(old);
        } else {
           // mapper.insertTModel(tModel);
            mapper.insert(tModel);

            if (Objects.nonNull(tModel.getTypeIds()) && !tModel.getTypeIds().isEmpty()){
                mapper.insertTModelTypeRelevance(tModel.getId(),tModel.getTypeIds());
            }
        }
        return ObjectRestResponse.succ();
    }


    public ObjectRestResponse getList(TModelDTO tModelDTO) {
        Query query = new Query(tModelDTO);
        PageDataVO<TModel> pageDataVO = PageDataVO.pageInfo(query, () -> mapper.selectList(query.getSuper()));
        pageDataVO.getData().forEach(tModel -> {
           List<Long> typeIds = mapper.selectTypeIds(tModel);
           tModel.setTypeIds(typeIds);
        });
        return ObjectRestResponse.succ(pageDataVO);
    }
}




