package com.upyuns.platform.rs.website.biz;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.website.dto.NoticeInfoDto;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import com.upyuns.platform.rs.website.entity.NoticeInfo;
import com.upyuns.platform.rs.website.mapper.NoticeInfoMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import tk.mybatis.mapper.entity.Example;

import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * 通知信息
 *
 * @author zjw
 * @email jiaoruizhen@126.com
 * @date 2020-12-28 14:12:25
 */
@Service
public class NoticeInfoBiz extends BaseBiz<NoticeInfoMapper,NoticeInfo> {

	public void addObj(String message, Integer type, Integer userId, String relationId) {
			insertSelectiveRe(new NoticeInfo(){{setMessage(message); setType(type); setUserId(userId); setRelationId(relationId); setCrtTime(new Date());setUpdTime(new Date());}});
	}

	/**
	 * 查询用户所有通知信息
	 * @param noticeInfoDto
	 * @return
	 */
	public ObjectRestResponse getByUserId(NoticeInfoDto noticeInfoDto) {
		Example example = new Example(NoticeInfo.class);
		Example.Criteria criteria = example.createCriteria();
		if (noticeInfoDto.getRead() != null) {
			criteria.andEqualTo("isRead", noticeInfoDto.getRead());
		}
		criteria.andEqualTo("userId", noticeInfoDto.getUserId());
		criteria.andEqualTo("isDel", 0);
		example.orderBy("isRead");
		example.orderBy("crtTime").desc();
		Query query = new Query(noticeInfoDto);
		PageDataVO<NoticeInfo> pageDataVO = PageDataVO.pageInfo(query, () -> mapper.selectByExample(example));
		return ObjectRestResponse.succ(pageDataVO);
	}


	public ObjectRestResponse deleteOne(Integer id) {
		if (id == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		NoticeInfo noticeInfo = selectById(id);
		if (noticeInfo == null || noticeInfo.getIsDel() == 1) {
			return ObjectRestResponse.createFailedResult(ResultCode.NOTEXIST_CODE, ResultCode.getMsg(ResultCode.NOTEXIST_CODE));
		}
		noticeInfo.setIsDel(1);
		updateSelectiveByIdRe(noticeInfo);
		return ObjectRestResponse.succ();
	}

	/**
	 * 设置为已读
	 * @param id
	 * @return
	 */
	public ObjectRestResponse updateRead(Integer id) {
		if (id == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		NoticeInfo noticeInfo = selectById(id);
		if (noticeInfo == null || noticeInfo.getIsDel() == 1) {
			return ObjectRestResponse.createFailedResult(ResultCode.NOTEXIST_CODE, ResultCode.getMsg(ResultCode.NOTEXIST_CODE));
		}
		noticeInfo.setIsRead(2);
		updateSelectiveByIdRe(noticeInfo);
		return ObjectRestResponse.succ();
	}

	/**
	 * 设置为已读
	 * @param ids
	 * @return
	 */
	public ObjectRestResponse updateAllRead(String ids) {
		if (StringUtils.isBlank(ids)) {
			return ObjectRestResponse.paramIsEmpty();
		}
		String[] arr = ids.split(",");
		if (arr == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		for (String id : arr) {
			updateRead(Integer.parseInt(id));
		}
		return ObjectRestResponse.succ();
	}


	public ObjectRestResponse updateAll(NoticeInfoDto noticeInfoDto) {
		Example example = new Example(NoticeInfo.class);
		Example.Criteria criteria = example.createCriteria();
		criteria.andEqualTo("isRead", 1);
		criteria.andEqualTo("userId", noticeInfoDto.getUserId());
		List<NoticeInfo> list = mapper.selectByExample(example);
		if (list != null && list.size() > 0) {
			list.forEach(noticeInfo -> {
				noticeInfo.setIsRead(2);
				updateSelectiveByIdRe(noticeInfo);
			});
		}
		return ObjectRestResponse.succ();
	}


	public ObjectRestResponse countObj(NoticeInfoDto noticeInfoDto) {
		Example example = new Example(NoticeInfo.class);
		Example.Criteria criteria = example.createCriteria();
		criteria.andEqualTo("isRead", 1);
		criteria.andEqualTo("userId", noticeInfoDto.getUserId());
		criteria.andEqualTo("isDel", 0);
		return ObjectRestResponse.succ(mapper.selectCountByExample(example));
	}
}