package com.upyuns.platform.rs.website.biz;

import cn.hutool.core.collection.CollUtil;
import com.github.wxiaoqi.security.common.util.TreeUtil;
import com.github.wxiaoqi.security.common.vo.TreeNode;
import com.upyuns.platform.rs.website.entity.GainData;
import com.upyuns.platform.rs.website.vo.DataMenuTree;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.upyuns.platform.rs.website.entity.DataMenu;
import com.upyuns.platform.rs.website.mapper.DataMenuMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import tk.mybatis.mapper.entity.Example;

import java.util.ArrayList;
import java.util.List;

/**
 * 菜单
 *
 * @author zjw
 * @email jiaoruizhen@126.com
 * @date 2024-05-15 18:31:37
 */
@Service
public class DataMenuBiz extends BaseBiz<DataMenuMapper,DataMenu> {

    @Autowired
    GainDataBiz gainDataBiz;


    public List<DataMenuTree> getImageMenuTree(List<DataMenu> menus, int root) {
        List<DataMenuTree> trees = new ArrayList<DataMenuTree>();
        DataMenuTree node = null;
        for (DataMenu imageMenu : menus) {
            node = new DataMenuTree();
            BeanUtils.copyProperties(imageMenu, node);
            node.setLabel(imageMenu.getTitle());
            node.setElements(gainDataBiz.selectAll(new GainData(){{
                setMenuId(imageMenu.getId());
            }}));
            if (node.getChildren() == null) {
                node.setChildren(new ArrayList<>());
            }
            trees.add(node);
        }
        return TreeUtil.bulid(trees,root);
    }

    public List<DataMenuTree> getImageMenuStatsTree(List<GainDataBiz.DataMenuStats> menus, int root) {
        List<DataMenuTree> trees = new ArrayList<DataMenuTree>();
        DataMenuTree node = null;
        for (GainDataBiz.DataMenuStats imageMenu : menus) {
            node = new DataMenuTree();
            BeanUtils.copyProperties(imageMenu, node);
            node.setLabel(imageMenu.getTitle());
            node.setDataNum(imageMenu.getDataNum());
            if (node.getChildren() == null) {
                node.setChildren(new ArrayList<>());
            }
            trees.add(node);
        }
        return TreeUtil.bulid(trees,root);
    }

    public List<DataMenuTree> getImageMenuTreeNoElements(List<DataMenu> menus, int root) {
        List<DataMenuTree> trees = new ArrayList<DataMenuTree>();
        DataMenuTree node = null;
        for (DataMenu imageMenu : menus) {
            node = new DataMenuTree();
            BeanUtils.copyProperties(imageMenu, node);
            node.setLabel(imageMenu.getTitle());
            if (node.getChildren() == null) {
                node.setChildren(new ArrayList<>());
            }
            trees.add(node);
        }
        return TreeUtil.bulid(trees,root);
    }

    public List<Integer> getIdsByTopId(int root) {
        Example exampleDataMenu = new Example(DataMenu.class);
        exampleDataMenu.createCriteria().andNotEqualTo("id", root);
        exampleDataMenu.setOrderByClause("order_num asc, id asc");
        List<DataMenu> menus = selectByExample(exampleDataMenu);
        List<Integer> list = CollUtil.newArrayList(root);
        List<DataMenuTree> trees = getImageMenuTreeNoElements(menus, root);
        dealIds(trees, list);
        return list;
    }

    public void dealIds(List<? extends TreeNode> menuTrees, List<Integer> ids) {
        if(CollUtil.isNotEmpty(menuTrees)) {
            for(TreeNode dataMenuTree : menuTrees) {
                ids.add(dataMenuTree.getId());
                dealIds(dataMenuTree.getChildren(), ids);
            }
        }
    }
}
