package com.upyuns.platform.rs.website.biz;


import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.website.dto.ApiCustomNodeDTO;
import com.upyuns.platform.rs.website.entity.ApiCustomNode;
import com.upyuns.platform.rs.website.entity.ApiCustomParams;
import com.upyuns.platform.rs.website.entity.ApiDoc;
import com.upyuns.platform.rs.website.mapper.ApiCustomNodeMapper;

import com.upyuns.platform.rs.website.mapper.ApiCustomParamsMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import javax.annotation.Resource;
import java.util.Objects;

/**
 *
 */
@Service
public class ApiCustomNodeBiz extends BaseBiz<ApiCustomNodeMapper, ApiCustomNode> {


    @Autowired
    private ApiDocBiz apiDocBiz;

    @Resource
    private ApiCustomParamsMapper apiCustomParamsMapper;

    public ObjectRestResponse getListByAPiDocId(Integer id) {
        ApiDoc apiDoc = apiDocBiz.selectById(id);
        if (apiDoc == null || Objects.equals(apiDoc.getIsDel(),1)) {
            return ObjectRestResponse.succ("文档不存在");
        }
        Example example = new Example(ApiCustomNode.class);
        example.createCriteria()
                .andEqualTo("docId",apiDoc.getId())
                .andEqualTo("isDel", 0);
        example.setOrderByClause("seq_no desc");
        example.excludeProperties("respondJson");
        return ObjectRestResponse.succ(mapper.selectByExample(example));
    }

    public ObjectRestResponse getListById(Integer id) {
        Example exampleNode = new Example(ApiCustomNode.class);
        exampleNode.createCriteria()
                .andEqualTo("id",id)
                .andEqualTo("isDel",0);
        ApiCustomNode node = mapper.selectOneByExample(exampleNode);
        Example exampleParams = new Example(ApiCustomParams.class);
        exampleParams.createCriteria()
                .andEqualTo("docId",node.getDocId())
                .andEqualTo("isDel",0)
                .andEqualTo("nodeId",node.getId());
        ApiCustomParams apiCustomParams = apiCustomParamsMapper.selectOneByExample(exampleParams);
        JSONObject result = new JSONObject();
        result.put("apiInfo",node);
        result.put("apiUrlInfo",apiCustomParams);
        return ObjectRestResponse.succ(result);
    }

    public ObjectRestResponse addObj(ApiCustomNode apiCustomNode) {
        if (apiCustomNode == null) {
            return ObjectRestResponse.paramIsEmpty();
        }
        //判断文档是否存在
        if (Objects.nonNull(apiCustomNode.getDocId()) && apiCustomNode.getDocId() > 0){
            Example exampleDoc = new Example(ApiDoc.class);
            exampleDoc.createCriteria()
                    .andEqualTo("id", apiCustomNode.getDocId())
                    .andEqualTo("isDel",0);
            if(apiDocBiz.selectCountByExample(exampleDoc) <= 0){
                return ObjectRestResponse.createFailedResult(ResultCode.NOTEXIST_CODE, "文档不存在");
            }
        }
        if (apiCustomNode.getId() != null) {
            ApiCustomNode old = selectById(apiCustomNode.getId());
            if (old == null || old.getIsDel() == 1) {
                return ObjectRestResponse.createFailedResult(ResultCode.NOTEXIST_CODE, ResultCode.getMsg(ResultCode.NOTEXIST_CODE));
            }
            BeanUtil.copyProperties(apiCustomNode, old, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
            updateSelectiveByIdRe(old);
        } else {
            insertSelectiveRe(apiCustomNode);
        }
        return ObjectRestResponse.succ();
    }

    public ObjectRestResponse getListV2(ApiCustomNodeDTO apiCustomNodeDTO) {
        Query query = new Query(apiCustomNodeDTO);
        PageDataVO<ApiCustomNode> pageDataVO = PageDataVO.pageInfo(query, () -> mapper.selectList(query.getSuper()));
        return ObjectRestResponse.succ(pageDataVO);
    }
}




