package com.upyuns.platform.rs.website.type;

import lombok.Data;

/**
 * @ClassName : OrderInvoiceStatus
 * @Description : 订单发票状态
 * @Author : jiaoruizhen
 * @Date: 2020-12-17 15:39
 * 发票状态： 1、未开发票，2、已开发票, 3、已发货， 4、已收货、5、退回， 6、已完成
 */
public enum  OrderInvoiceStatusEnum {
	INVOICE_NO_OPEN(1, "未开发票"),
	INVOICE_OPEN(2, "已开发票"),
	INVOICE_SEND(3, "已发货"),
	INVOICE_RECEIVED(4, "已收货"),
	INVOICE_REFUND(5, "退回"),
	INVOICE_COMPLETE(6, "已完成"),
	;
	private Integer type;
	private String msg;

	OrderInvoiceStatusEnum(Integer type, String msg) {
		this.type = type;
		this.msg = msg;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}


	public static <T extends OrderInvoiceStatusEnum> String getType(Integer code, Class<T> t) {
		for (T item : t.getEnumConstants()) {
			if (item.getType().equals(code)) {
				return item.getMsg();
			}
		}
		return "";
	}

	public static OrderInvoiceStatusEnum getByCode(Integer code) {
		for (OrderInvoiceStatusEnum v : values()) {
			if (v.getType() == code) {
				return v;
			}
		}
		return null;
	}

	public static String getProductStatusEnum(Integer code) {
		return getType(code, OrderInvoiceStatusEnum.class);
	}
}
