package com.upyuns.platform.rs.website.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 用户发票信息
 * 
 * @author jiaoruizhen
 * @email jiaoruizhen@126.com
 * @date 2020-12-03 13:29:23
 */
@Data
@Table(name = "user_invoice")
public class UserInvoice implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  
   */
    @Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty("")
    private Integer id;
	
	    /**
     *  用户id
     */
    @Column(name = "user_id")
	@ApiModelProperty(value = "用户id")
    private Integer userId;
	
	    /**
     *  发票抬头类型：1--企业单位；2--个人/非企业单位
     */
    @Column(name = "title_type")
	@ApiModelProperty(value = "发票抬头类型：1--企业单位；2--个人/非企业单位")
    private Integer titleType;
	
	    /**
     *  抬头名称
     */
    @Column(name = "title_name")
	@ApiModelProperty(value = "抬头名称")
    private String titleName;
	
	    /**
     *  税号
     */
    @Column(name = "tax_code")
	@ApiModelProperty(value = "税号")
    private String taxCode;
	
	    /**
     *  发票内容-备注说明
     */
    @Column(name = "content_remark")
	@ApiModelProperty(value = "发票内容-备注说明")
    private String contentRemark;
	
	    /**
     *  收票地址
     */
    @Column(name = "address")
	@ApiModelProperty(value = "收票地址")
    private String address;
	
	    /**
     *  收票电话
     */
    @Column(name = "phone")
	@ApiModelProperty(value = "收票电话")
    private String phone;
	
	    /**
     *  账号
     */
    @Column(name = "account")
	@ApiModelProperty(value = "账号")
    private String account;
	
	    /**
     *  开户行
     */
    @Column(name = "open_bank")
	@ApiModelProperty(value = "开户行")
    private String openBank;
	
	    /**
     *  
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "", hidden = true )
    private Date crtTime;
	
	    /**
     *  
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "", hidden = true )
    private Date updTime;
	
	    /**
     *  营业执照地址
     */
    @Column(name = "file_path")
	@ApiModelProperty(value = "营业执照地址")
    private String filePath;

    private Integer isDel;

	/**
	 * 发票类型： 1、普通发票，2、专票
	 */
	private Integer type;

	/**
	 * 是否是默认值： 0、否，1、是
	 */
	private Integer isDefault;


	/**
	 * 省份
	 */
	@Column(name = "province")
	@ApiModelProperty(value = "省份")
	private String province;

	/**
	 * 市
	 */
	@Column(name = "city")
	@ApiModelProperty(value = "市")
	private String city;

	/**
	 * 乡镇/街道
	 */
	@Column(name = "town")
	@ApiModelProperty(value = "乡镇/街道")
	private String town;

}
