package com.upyuns.platform.rs.website.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.Data;

/**
 * 模型类型
 * @TableName t_model_type
 */
@Table(name="t_model_type")
@Data
public class TModelType implements Serializable {
    /**
     *
     */
    @Id
    private Integer id;

    /**
     * 模型类型名称
     */
    private String name;

    /**
     * 父id
     */
    private Integer pid;

    /**
     * 状态：1.上架 2.下架
     */
    private Byte status;

    /**
     * 是否删除：0、否， 1、是
     */
    @Column(name = "is_del")
    private Byte isDel;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    private Date createTime;

    /**
     * 创建人
     */
    @Column(name = "create_user")
    private Long createUser;

    /**
     * 更新时间
     */
    @Column(name = "last_update_time")
    private Date lastUpdateTime;

    /**
     * 更新人
     */
    @Column(name = "last_update_user")
    private Long lastUpdateUser;

    private static final long serialVersionUID = 1L;
}
