package com.upyuns.platform.rs.website.entity;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 模型
 * @TableName t_model
 */
@Table(name="t_model")
@Data
public class TModel implements Serializable {
    /**
     * 模型ID
     */
    @Id
    private Integer id;

    /**
     * 模型中文
     */
    @Column(name = "model_cn")
    private String modelCn;

    /**
     * 模型英文
     */
    @Column(name = "model_en")
    private String modelEn;

    /**
     * 简介
     */
    @Column(name = "intro")
    private String intro;

    /**
     *
     */
    @Column(name = "model_unit_name")
    private String modelUnitName;

    /**
     * 收藏量
     */
    private Long favorites;

    /**
     * 浏览量
     */
    private Long views;

    /**
     * 参数量
     */
    private Long parameters;

    /**
     * 发布单位
     */
    @Column(name = "released_by")
    private String releasedBy;

    /**
     *
     */
    @Column(name = "model_position")
    private String modelPosition;

    /**
     * 发布时间
     */
    @Column(name = "release_time")
    private Date releaseTime;

    /**
     * 是否在线体验
     */
    @Column(name = "is_online_experience")
    private String isOnlineExperience;

    /**
     * API
     */
    @Column(name = "online_experience_api")
    private String onlineExperienceApi;

    /**
     * 详情富文本
     */
    private String details;

    /**
     * 版本号
     */
    @Column(name = "model_version")
    private Integer modelVersion;

    /**
     * 软件框架
     */
    @Column(name = "software_framework")
    private String softwareFramework;

    /**
     * 硬件类型
     */
    @Column(name = "hardware_type")
    private String hardwareType;

    /**
     * 审核状态：1.待审核 2.通过 3.拒绝
     */
    @Column(name = "examine_status")
    private Byte examineStatus;

    /**
     * 状态：1.上架 2.下架
     */
    private Byte status;

    /**
     * 是否删除：0、否， 1、是
     */
    @Column(name = "is_del")
    private Byte isDel;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    private Date createTime;

    /**
     * 创建人
     */
    @Column(name = "create_user")
    private Long createUser;

    /**
     * 更新时间
     */
    @Column(name = "last_update_time")
    private Date lastUpdateTime;

    /**
     * 更新人
     */
    @Column(name = "last_update_user")
    private Long lastUpdateUser;

    private static final long serialVersionUID = 1L;

    private List<Long> typeIds;
}
