package com.upyuns.platform.rs.website.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 成果数据
 * 
 * @author zjw
 * @email jiaoruizhen@126.com
 * @date 2024-05-15 18:31:38
 */
@Data
@Table(name = "gain_data")
public class GainData implements Serializable {
	private static final long serialVersionUID = 1L;


    public static final int HASGTDATA_NOT = 0;
    public static final int HASGTDATA_FIN = 1;
    public static final int HASGTDATA_UPD = 2;

	    /**
    *  id
   */
    @Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty("id")
    private Integer id;
	
	    /**
     *  名称
     */
    @Column(name = "name")
	@ApiModelProperty(value = "名称")
    private String name;
	
	    /**
     *  时间
     */
    @Column(name = "time")
	@ApiModelProperty(value = "时间")
    private String time;
	
	    /**
     *  排序
     */
    @Column(name = "rank")
	@ApiModelProperty(value = "排序")
    private Integer rank;

    @Column(name = "areaIntroduction")
    @ApiModelProperty(value = "区域介绍")
    private String areaIntroduction;

    @Column(name = "detailintroduce")
    @ApiModelProperty(value = "详情介绍")
    private String detailintroduce;

    @Column(name = "level")
    @ApiModelProperty(value = "级别")
    private String level;



    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Date crtTime;
	
	    /**
     *  修改时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "修改时间", hidden = true )
    private Date updTime;
	
	    /**
     *  图片地址
     */
    @Column(name = "picture_url")
	@ApiModelProperty(value = "图片地址")
    private String pictureUrl;
	
	    /**
     *  是否删除，0否，1是
     */
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除，0否，1是")
    private Integer isDel;
	
	    /**
     *  状态1--上架；2--下架
     */
    @Column(name = "status")
	@ApiModelProperty(value = "状态2--上架；1--下架")
    private Integer status;
	
	    /**
     *  菜单id
     */
    @Column(name = "menu_id")
	@ApiModelProperty(value = "菜单id")
    private Integer menuId;

    @Column(name = "data_path")
    @ApiModelProperty(value = "数据路径")
    private String dataPath;

    @Column(name = "gtdata_path")
    @ApiModelProperty(value = "gtdata路径")
    private String gtdataPath;

    @Column(name = "has_gtdata")
    @ApiModelProperty(value = "是否已经存储gtdata 0--未处理；1--已处理；2--已更新")
    private Integer hasGtdata;

    @Column(name = "supplier")
    @ApiModelProperty(value = "供应商")
    private String supplier;

    @Column(name = "process_num")
    @ApiModelProperty(value = "加工次数")
    private Integer processNum;

    @Column(name = "distribute_num")
    @ApiModelProperty(value = "分发次数")
    private Integer distributeNum;
}
