package com.upyuns.platform.rs.website.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 数据临时缓存库
 * 
 * @author zjw
 * @email jiaoruizhen@126.com
 * @date 2024-08-14 14:52:35
 */
@Data
@Table(name = "data_tempcache")
public class DataTempcache implements Serializable {
	private static final long serialVersionUID = 1L;

	public static final int HASGTDATA_NOT = 0;
	public static final int HASGTDATA_FIN = 1;
	public static final int HASGTDATA_UPD = 2;

	public static final int UPTYPE_UPLOAD = 1;
	public static final int UPTYPE_GTDATA = 2;
	public static final int UPTYPE_URL = 3;

	    /**
    *  
   */
    @Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@ApiModelProperty("")
    private Integer id;
	
	    /**
     *  数据名称
     */
    @Column(name = "name")
	@ApiModelProperty(value = "数据名称")
    private String name;
	
	    /**
     *  数据类型 1--图片；2--栅格文件；3--图库
     */
    @Column(name = "type")
	@ApiModelProperty(value = "数据类型 1--图片；2--栅格文件；3--shp；4--压缩包")
    private Integer type;
	
	    /**
     *  数据来源 1--门户；2--生产线；3--AI系统
     */
    @Column(name = "source")
	@ApiModelProperty(value = "数据来源 1--门户；2--生产线；3--AI系统")
    private Integer source;
	
	    /**
     *  功能模块 0--默认；
     */
    @Column(name = "source_module")
	@ApiModelProperty(value = "功能模块 0--默认；")
    private String sourceModule;
	
	    /**
     *  文件名称
     */
    @Column(name = "filename")
	@ApiModelProperty(value = "文件名称")
    private String filename;
	
	    /**
     *  文件类型
     */
    @Column(name = "filetype")
	@ApiModelProperty(value = "文件类型")
    private String filetype;
	
	    /**
     *  文件地址
     */
    @Column(name = "fileurl")
	@ApiModelProperty(value = "文件地址")
    private String fileurl;
	
	    /**
     *  文件大小
     */
    @Column(name = "filesize")
	@ApiModelProperty(value = "文件大小")
    private String filesize;
	
	    /**
     *  是否删除 1--已删除；0--未删除
     */
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除 1--已删除；0--未删除")
    private Integer isDel;
	
	    /**
     *  属性信息
     */
    @Column(name = "detail_json")
	@ApiModelProperty(value = "属性信息")
    private String detailJson;
	
	    /**
     *  gtdata路径
     */
    @Column(name = "gtdata_path")
	@ApiModelProperty(value = "gtdata路径")
    private String gtdataPath;
	
	    /**
     *  是否已经存储gtdata 0--未处理；1--已处理；2--已更新
     */
    @Column(name = "has_gtdata")
	@ApiModelProperty(value = "是否已经存储gtdata 0--未处理；1--已处理；2--已更新")
    private Integer hasGtdata;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    /**
     *  创建人
     */
    @Column(name = "crt_user")
	@ApiModelProperty(value = "创建人")
    private String crtUser;
	
	    /**
     *  更新人
     */
    @Column(name = "upd_user")
	@ApiModelProperty(value = "更新人")
    private String updUser;
	
	    /**
     *  定制用户
     */
    @Column(name = "user_id")
	@ApiModelProperty(value = "定制用户")
    private Integer userId;
	
	    /**
     *  1--已提交;
     */
    @Column(name = "status")
	@ApiModelProperty(value = "1--已提交;")
    private Integer status;

	@Column(name = "remark")
	@ApiModelProperty(value = "备注描述")
	private String remark;

	@Column(name = "uptype")
	@ApiModelProperty(value = "上传类型 1--文件上传；2--gtdata路径；3--url")
	private Integer uptype;

	@Column(name = "upurl")
	@ApiModelProperty(value = "上传文件url地址")
	private String upurl;

	@ApiModelProperty(value = "文件服务器路径")
	private String filepath;

	@ApiModelProperty(value = "描述")
	private String descr;

	@ApiModelProperty(value = "标签信息")
	private String labelinfo;
}
