package com.upyuns.platform.rs.website.entity;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 *
 * @TableName api_custom_node
 */
@Table(name="api_custom_node")
@Data
public class ApiCustomNode implements Serializable {
    /**
     * 主键自增ID
     */
    @Id
    private Integer id;

    /**
     * api_doc主键ID
     */
    @Column(name = "doc_id")
    private Long docId;

    /**
     * 父文件夹ID
     */
    @Column(name = "parent_id")
    private Long parentId;

    /**
     * 节点类型 0=目录 1=接口
     */
    @Column(name = "node_type")
    private Byte nodeType;

    /**
     * 节点名称
     */
    @Column(name = "node_name")
    private String nodeName;

    /**
     * 节点说明
     */
    @Column(name = "node_desc")
    private String nodeDesc;

    /**
     * 路由
     */
    @Column(name = "path")
    private String path;


    /**
     * 节点顺序
     */
    @Column(name = "seq_no")
    private Integer seqNo;

    /**
     * 响应结果
     */
    @Column(name = "respond_json")
    private String respondJson;

    /**
     * 状态：1.上架 2.下架
     */
    private Byte status;

    /**
     * 是否删除：0、否， 1、是
     */
    @Column(name = "is_del")
    private Byte isDel;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    private Date createTime;

    /**
     * 创建人
     */
    @Column(name = "create_user")
    private Long createUser;

    /**
     * 更新时间
     */
    @Column(name = "last_update_time")
    private Date lastUpdateTime;

    /**
     * 更新人
     */
    @Column(name = "last_update_user")
    private Long lastUpdateUser;

    private static final long serialVersionUID = 1L;
}
