package com.upyuns.platform.rs.universal.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geojson.feature.FeatureJSON;
import org.geotools.geojson.geom.GeometryJSON;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

import java.io.*;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ShpToGeojson {
//    /**
//     * geojson转换为shp文件
//     *
//     * @param
//     * @param shpPath
//     * @return
//     */
//    public Map geojson2Shape(String jsonPath, String shpPath) {
//        Map map = new HashMap();
//        GeometryJSON gjson = new GeometryJSON();
//        try {
//            // 读文件到Stringbuffer
//            StringBuffer sb = new StringBuffer();
//            BufferedReader br = null;
//            try {
//                br = new BufferedReader(new FileReader(jsonPath));
//                String str;
//                while ((str = br.readLine()) != null) {// 逐行读取
//                    sb.append(str + "\r\n");
//                }
//                br.close();
//            } catch (Exception e) {
//                System.out.println(e.getMessage());
//            }
//            JSONObject json = JSONObject.parseObject(sb.toString());
////            JSONObject json = JSONObject.fromObject(sb.toString());
//            JSONArray features = (JSONArray) json.get("features");
//            JSONObject feature0 = JSONObject.parseObject(features.get(0).toString());
//            // 获取属性名称
//            Set properties = JSONObject.parseObject(feature0.getString("properties")).keySet();
//            String strType = ((JSONObject) feature0.get("geometry")).getString("type").toString();
//
//            Class<?> geoType = null;
//            switch (strType) {
//                case "Point":
//                    geoType = Point.class;
//                    break;
//                case "MultiPoint":
//                    geoType = MultiPoint.class;
//                    break;
//                case "LineString":
//                    geoType = LineString.class;
//                    break;
//                case "MultiLineString":
//                    geoType = MultiLineString.class;
//                    break;
//                case "Polygon":
//                    geoType = Polygon.class;
//                    break;
//                case "MultiPolygon":
//                    geoType = MultiPolygon.class;
//                    break;
//            }
//            // 创建shape文件对象
//            File file = new File(shpPath);
//            Map<String, Serializable> params = new HashMap<String, Serializable>();
//            params.put(ShapefileDataStoreFactory.URLP.key, file.toURI().toURL());
//            ShapefileDataStore ds = (ShapefileDataStore) new ShapefileDataStoreFactory().createNewDataStore(params);
//            // 定义图形信息和属性信息
//            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
//            tb.setCRS(DefaultGeographicCRS.WGS84);
//            tb.setName("shapefile");
//            tb.add("the_geom", geoType);// 类型，Point/MultiPoint/LineString/MultiLineString/Polygon/MultiPolygon
//            Iterator propertiesIter = properties.iterator();
//            // 设置属性
//            while (propertiesIter.hasNext()) {
//                String str = propertiesIter.next().toString();
//                tb.add(str, String.class);// 此处设置为string，如需修改请自行改写代码
//            }
//
//            ds.createSchema(tb.buildFeatureType());
//            // 设置编码
//            Charset charset = Charset.forName("GBK");
//            ds.setCharset(charset);
//            // 设置Writer
//            FeatureWriter<SimpleFeatureType, SimpleFeature> writer = ds.getFeatureWriter(ds.getTypeNames()[0],
//                    Transaction.AUTO_COMMIT);
//
//            for (int i = 0, len = features.size(); i < len; i++) {
//                String strFeature = features.get(i).toString();
//                Reader reader = new StringReader(strFeature);
//                SimpleFeature feature = writer.next();
//                switch (strType) {
//                    case "Point":
//                        feature.setAttribute("the_geom", gjson.readPoint(reader));
//                        break;
//                    case "MultiPoint":
//                        feature.setAttribute("the_geom", gjson.readMultiPoint(reader));
//                        break;
//                    case "LineString":
//                        feature.setAttribute("the_geom", gjson.readLine(reader));
//                        break;
//                    case "MultiLineString":
//                        feature.setAttribute("the_geom", gjson.readMultiLine(reader));
//                        break;
//                    case "Polygon":
//                        feature.setAttribute("the_geom", gjson.readPolygon(reader));
//                        break;
//                    case "MultiPolygon":
//                        feature.setAttribute("the_geom", gjson.readMultiPolygon(reader));
//                        break;
//                }
//                Iterator propertiesset = properties.iterator();
//                while (propertiesset.hasNext()) {
//                    String str = propertiesset.next().toString();
//                    JSONObject featurei = JSONObject.parseObject(features.get(i).toString());
//                    feature.setAttribute(str, JSONObject.parseObject(featurei.getString("properties")).get(str));
//                }
//                writer.write();
//            }
//            writer.close();
//            ds.dispose();
//            map.put("status", "success");
//            map.put("message", shpPath);
//        } catch (Exception e) {
//            map.put("status", "failure");
//            map.put("message", e.getMessage());
//            e.printStackTrace();
//        }
//        return map;
//    }

    /**
     * shp文件转换geojson数据
     * @param shpPath
     * @return
     */
    public static String shp2OneGeojson(String shpPath){
        Map map = new HashMap();
        //新建json对象
        FeatureJSON fjson = new FeatureJSON();
        JSONObject geojsonObject=new JSONObject();
        geojsonObject.put("type","FeatureCollection");
        Object geometry = new JSONObject();
        try{
            //获取featurecollection
            File file = new File(shpPath);
            ShapefileDataStore shpDataStore = null;
            shpDataStore = new ShapefileDataStore(file.toURL());
            //设置编码
/*            Charset charset = Charset.forName("GBK");
            shpDataStore.setCharset(charset);*/
            String typeName = shpDataStore.getTypeNames()[0];
            SimpleFeatureSource featureSource = null;
            featureSource =  shpDataStore.getFeatureSource (typeName);
            SimpleFeatureCollection result = featureSource.getFeatures();
            SimpleFeatureIterator itertor = result.features();
            //遍历feature转为json对象
            while (itertor.hasNext())
            {
                SimpleFeature feature = itertor.next();
                StringWriter writer = new StringWriter();
                fjson.writeFeature(feature, writer);
                String temp=writer.toString();
                geometry = JSONObject.parseObject(temp).getString("geometry");
                byte[] b=temp.getBytes("iso8859-1");
                temp=new String(b,"gbk");
                JSONObject json =  JSON.parseObject(temp);
                break;
            }
            itertor.close();
        }
        catch(Exception e){
            map.put("status", "failure");
            map.put("message", e.getMessage());
            e.printStackTrace();
        }
        return geometry.toString();
    }

    /**
     * shp文件转换geojson数据
     * @param shpPath
     * @return
     */
    public static String shp2geojson(String shpPath)
    {
        Map map = new HashMap();
        //新建json对象
        FeatureJSON fjson = new FeatureJSON();
        JSONObject geojsonObject=new JSONObject();
        geojsonObject.put("type","FeatureCollection");
        try{
            //获取featurecollection
            File file = new File(shpPath);
            ShapefileDataStore shpDataStore = null;
            shpDataStore = new ShapefileDataStore(file.toURL());
            //设置编码
/*            Charset charset = Charset.forName("GBK");
            shpDataStore.setCharset(charset);*/
            String typeName = shpDataStore.getTypeNames()[0];
            SimpleFeatureSource featureSource = null;
            featureSource =  shpDataStore.getFeatureSource (typeName);
            SimpleFeatureCollection result = featureSource.getFeatures();
            SimpleFeatureIterator itertor = result.features();
            JSONArray array = new JSONArray();
            //遍历feature转为json对象
            while (itertor.hasNext())
            {
                SimpleFeature feature = itertor.next();
                StringWriter writer = new StringWriter();
                fjson.writeFeature(feature, writer);
                String temp=writer.toString();
                Object geometry = JSONObject.parseObject(temp).getString("geometry");
                byte[] b=temp.getBytes("iso8859-1");
                temp=new String(b,"gbk");
                JSONObject json =  JSON.parseObject(temp);
                array.add(geometry);
            }
            itertor.close();
//            return array;
            geojsonObject.put("features",array);
            return JSON.toJSONString(geojsonObject);
//            itertor.close();

//            long startTime=System.currentTimeMillis();

            //将json字符串使用字符流写入文件
/*            File outputfile=new File(jsonPath);
            BufferedWriter bufferedWriter=new BufferedWriter(new FileWriter(outputfile));
            bufferedWriter.write(JSON.toJSONString(geojsonObject));
            bufferedWriter.flush();
            bufferedWriter.close();*/
//            File outputfile=new File(jsonPath);
//            FileOutputStream fileOutputStream=new FileOutputStream(outputfile);
//            OutputStreamWriter outputStreamWriter=new OutputStreamWriter(fileOutputStream,"utf-8");
//            outputStreamWriter.write(JSON.toJSONString(geojsonObject));
//            outputStreamWriter.flush();
//            outputStreamWriter.close();

            //将json字符串使用字节流写入文件
/*            File outputfile=new File(jsonPath);
            BufferedOutputStream bufferedOutputStream=new BufferedOutputStream(new FileOutputStream(outputfile));
            byte[] bytes= JSON.toJSONString(geojsonObject).getBytes("utf-8");
            bufferedOutputStream.write(bytes);
            //fileOutputStream.write(JSON.toJSONString(geojsonObject));
            bufferedOutputStream.flush();
            bufferedOutputStream.close();*/

//            long endTime=System.currentTimeMillis();
//            System.out.println("当前程序耗时："+(endTime-startTime)+"ms");
        }
        catch(Exception e){
            map.put("status", "failure");
            map.put("message", e.getMessage());
            e.printStackTrace();

        }
//
//        return geojsonObject;
        return JSON.toJSONString(geojsonObject);
    }

    /**
     * 工具类测试方法
     *
     * @param args
     */
    public static void main(String[] args) {
        ShpToGeojson shpToGeojson = new ShpToGeojson();
        long start = System.currentTimeMillis();
        // shape2Geojson
//      String shpPath = "D:/geojsonTest/gaosu.shp";
//      String jsonPath = "D:/geojsonTest/gaosu.geojson1";
//      Map map = fileFormat.shape2Geojson(shpPath, jsonPath);

        // geojson2Shape
        String shpPath = "D:/矢量下载/123.shp";
        String jsonPath = "D:/123.geojson";
//        Map map = shpToGeojson.geojson2Shape(jsonPath, shpPath);

        System.out.println(shpPath +" "+ jsonPath + ",共耗时" + (System.currentTimeMillis() - start) + "ms");
    }
}
