package com.upyuns.platform.rs.universal.controller;




import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.upyuns.platform.rs.universal.biz.OrderPayBiz;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 用户
 */
@RestController
@RequestMapping("info")
@IgnoreUserToken
@Slf4j
public class UserInfoController {

    @Autowired
    OrderPayBiz orderPayBiz;

    @GetMapping("/app/unauth/getAliPayUserInfo")
    public ObjectRestResponse<String> getAliPayUserInfo(String code) {
        try {
            return ObjectRestResponse.succ(orderPayBiz.getAlipayToken(code));
        } catch (AlipayApiException e) {
            log.error(e.getMessage(), e);
        }
        return ObjectRestResponse.createDefaultFail();
    }

    @GetMapping("/app/unauth/alipayUserAuth")
    public ObjectRestResponse<String> alipayUserAuth() {
        try {
            JSONObject jsonObject = JSONObject.parseObject(orderPayBiz.alipayUserAuth());
            return ObjectRestResponse.succ(jsonObject);
        } catch (AlipayApiException e) {
            log.error(e.getMessage(), e);
        }
        return ObjectRestResponse.createDefaultFail();
    }

    @GetMapping("/app/unauth/getParam")
    public ObjectRestResponse<String> getParam(String apiName, String appName) {
            return ObjectRestResponse.succ(orderPayBiz.generateAliPayInfo(apiName, appName));
    }

}

