package com.upyuns.platform.rs.universal;

import com.ace.cache.EnableAceCache;
import com.github.wxiaoqi.security.api.vo.config.HeaderConfig;
import com.github.wxiaoqi.security.auth.client.EnableAceAuthClient;
import com.github.wxiaoqi.security.common.annotation.AddBasicConfiguration;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@SpringBootApplication(scanBasePackages = {
        "com.upyuns.platform.rs",
        "com.github.wxiaoqi.security.common.handler"
}, excludeName = {"com.upyuns.platform.rs.gtdata"})
@EnableDiscoveryClient
@EnableAceAuthClient
@EnableScheduling
@EnableAceCache
@EnableTransactionManagement
@AddBasicConfiguration
@tk.mybatis.spring.annotation.MapperScan(basePackages = "com.upyuns.platform.rs.universal.mapper")
@EnableFeignClients(value = {"com.upyuns.platform.rs","com.github.wxiaoqi.security"},defaultConfiguration = HeaderConfig.class)
public class UniversalApplication {
    public static void main(String[] args) {
        SpringApplication.run(UniversalApplication.class, args);
    }
}
