package com.upyuns.platform.rs.datacenter.rest.backstage;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.datacenter.biz.RscpMonitorimageBiz;
import com.upyuns.platform.rs.datacenter.entity.RscpMonitorimage;
import com.upyuns.platform.rs.datacenter.entity.RscpMosaicimage;
import com.upyuns.platform.rs.datacenter.pojo.imagedata.RscpMosaicimageDTO;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import tk.mybatis.mapper.entity.Example;
@RestController
@RequestMapping("/bg/rscpMonitorimage")
public class BgRscpmonitorimageController extends BaseController<RscpMonitorimageBiz, RscpMonitorimage> {


    @ApiOperation("信息产品管理")
    @RequestMapping(value = "/mapAll",method = RequestMethod.GET)
    public ObjectRestResponse<PageDataVO<RscpMonitorimage>> getPageList(RscpMosaicimageDTO dto) throws Exception {
        Example example = new Example(RscpMosaicimage.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isDel",0);
        if (StringUtils.isNotBlank(dto.getName())){
            criteria.andLike("title", "%" + dto.getName() + "%");
        }
        example.setOrderByClause("id desc");
        PageDataVO pageDataVO = PageDataVO.pageInfo(dto.getPage(), dto.getLimit(), ()->baseBiz.selectByExample(example));
        return ObjectRestResponse.succ(pageDataVO);
    }

    @RequestMapping(value = "/addRscpMosaicimage",method = RequestMethod.POST)
    public ObjectRestResponse <RscpMonitorimage> addMosaicimage(@RequestBody RscpMonitorimage rscpMonitorimage ) {
        if (rscpMonitorimage.getId()==null){
            rscpMonitorimage.setIsDel(0);
            baseBiz.insertSelective(rscpMonitorimage);
        }else {
            rscpMonitorimage.setIsDel(0);
            baseBiz.updateSelectiveById(rscpMonitorimage);
        }
        return ObjectRestResponse.succ();
    }



    @DeleteMapping("/deleteById")
    public ObjectRestResponse deleteInoPortAnalyse(Integer id) {
        RscpMonitorimage rscpMonitorimage = new RscpMonitorimage();
        rscpMonitorimage.setId(id);
        rscpMonitorimage.setIsDel(1);
        baseBiz.updateSelectiveById(rscpMonitorimage);
        return ObjectRestResponse.succ();
    }


}
