package com.upyuns.platform.rs.datacenter.rest.backstage;

import cn.hutool.core.util.StrUtil;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.datacenter.biz.RscpImageCoverBiz;
import com.upyuns.platform.rs.datacenter.biz.RscpImageStatisticsBiz;
import com.upyuns.platform.rs.datacenter.entity.RscpImageCover;
import com.upyuns.platform.rs.datacenter.entity.RscpImageStatistics;
import com.upyuns.platform.rs.datacenter.pojo.BgImageCoverQueryDTO;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_FALSE;

@RestController
@RequestMapping("/bg/cover")
public class BgRscpImageCoverController extends BaseController<RscpImageCoverBiz, RscpImageCover> {

    @ApiOperation("查询分页")
    @RequestMapping(value = "/bgPages",method = RequestMethod.GET)
    @ResponseBody
    public ObjectRestResponse<PageDataVO<RscpImageCover>> bgPages(BgImageCoverQueryDTO dto) {
        if(StrUtil.isNotBlank(dto.getDateMonth())) {
            if(dto.getDateMonth().length() < 2) {
                dto.setDateMonth("0"+ dto.getDateMonth());
            }
        }
        return ObjectRestResponse.succ(PageDataVO.pageInfo(dto.initQuery(), () -> baseBiz.bgQueryDataList(dto)));
    }

    @ApiOperation("定时处理")
    @RequestMapping(value = "/app/unauth/coverTask",method = RequestMethod.GET)
    @ResponseBody
    @IgnoreUserToken
    @IgnoreClientToken
    public ObjectRestResponse coverTask() {
        baseBiz.coverTask();
        return ObjectRestResponse.succ();
    }
}