package com.upyuns.platform.rs.datacenter.rest;

import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.upyuns.platform.rs.datacenter.biz.RscpMonitorimageBiz;
import com.upyuns.platform.rs.datacenter.biz.RscpMosaicimageBiz;
import com.upyuns.platform.rs.datacenter.entity.RscpImageDataNewest;
import com.upyuns.platform.rs.datacenter.entity.RscpMonitorimage;
import com.upyuns.platform.rs.datacenter.entity.RscpMosaicimage;
import com.upyuns.platform.rs.datacenter.pojo.RscpImageDataNewestDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

@RestController
@RequestMapping("/web/rscpMonitorimage")
public class RscpMonitorimageController extends BaseController<RscpMonitorimageBiz, RscpMonitorimage> {

    @ApiModelProperty("检测图斑最新时间分页")
    @IgnoreUserToken
    @RequestMapping(value = "/app/unauth/mapAll",method = RequestMethod.GET)
    public ObjectRestResponse<List<RscpMonitorimage>> getPageList(RscpImageDataNewestDTO dto) {
        Example example = new Example(RscpMonitorimage.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("status",2);
        criteria.andEqualTo("isDel",0);
        example.setOrderByClause("start_time DESC");
        PageDataVO pageDataVO = PageDataVO.pageInfo(dto.getPage(), dto.getLimit(), ()->baseBiz.selectByExample(example));
        return ObjectRestResponse.succ(pageDataVO);
    }




    @ApiModelProperty("检测图斑热度")
    @IgnoreUserToken
    @RequestMapping(value = "/app/unauth/hotall",method = RequestMethod.GET)
    public ObjectRestResponse<List<RscpMonitorimage>> all(RscpImageDataNewestDTO dto) {
        Example example = new Example(RscpMonitorimage.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("status",2);
        criteria.andEqualTo("isDel",0);
        example.setOrderByClause("hot DESC");
        PageDataVO pageDataVO = PageDataVO.pageInfo(dto.getPage(), dto.getLimit(), ()->baseBiz.selectByExample(example));
        return ObjectRestResponse.succ(pageDataVO);
    }
    @RequestMapping(value = "/app/unauth/all", method = RequestMethod.GET)
    @IgnoreUserToken
    public ObjectRestResponse unauthQuery() {

        List<RscpMonitorimage> list = baseBiz.selectByWeekend(w -> {
            w.andEqualTo(RscpMonitorimage::getStatus, 2);
            w.andEqualTo(RscpMonitorimage::getIsDel, 0);
            return w;
        }, "start_time DESC");
        return ObjectRestResponse.succ(list);
    }
//
//    @RequestMapping(value = "/app/unauth/mapAll", method = RequestMethod.GET)
//    @IgnoreUserToken
//    public ObjectRestResponse mapAll(RscpImageDataNewestDTO dto) {
//
//        List<RscpMonitorimage> list = baseBiz.selectByWeekend(w -> {
//            w.andEqualTo(RscpMonitorimage::getStatus, 2);
//            return w;
//        }, "hot DESC");
//        PageInfo<RscpMonitorimage> pageInfo = new PageInfo<>(list);
//        PageDataVO pageData = new PageDataVO(pageInfo.getTotal(), pageInfo.getList());
//
//        return ObjectRestResponse.succ(pageData);
//    }
//
//    @Data
//    public class PageDataVO {
//        private long total;
//        private List<RscpMonitorimage> list;
//
//
//        public  PageDataVO(long total, List<RscpMonitorimage> list) {
//            this.total = total;
//            this.list = list;
//        }

//
//    }
}


