package com.upyuns.platform.rs.datacenter.job;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.github.wxiaoqi.security.common.vo.PageParam;
import com.upyuns.platform.rs.datacenter.biz.*;
import com.upyuns.platform.rs.datacenter.entity.*;
import com.upyuns.platform.rs.datacenter.pojo.imagedata.InsertCoverDTO;
import com.upyuns.platform.rs.datacenter.vo.MaxMinVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_FALSE;
import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_TRUE;

@Configuration      //1.主要用于标记配置类，兼备Component的效果。
@EnableScheduling   // 2.开启定时任务
@Slf4j
public class CoverScheduleTask {

    @Autowired
    RscpImagePriceBiz rscpImagePriceBiz;

    @Autowired
    RscpImageDataTotalBiz rscpImageDataTotalBiz;

    @Autowired
    RscpImageStatisticsBiz rscpImageStatisticsBiz;

    @Autowired
    RscpAreaImageTotalBiz rscpAreaImageTotalBiz;

    @Autowired
    RscpImageCoverBiz rscpImageCoverBiz;

    @Autowired
    RscpAreaInfoBiz rscpAreaInfoBiz;

    //定时按月份统计覆盖率(每天凌晨2:00)
    @Scheduled(cron = "0 0 2 * * ?")
    //@Scheduled(fixedRate=5000)
    public void configureTasks() {
        //定时统计覆盖率数据
        rscpImageCoverBiz.coverTask();
    }
}