
package com.upyuns.platform.rs.datacenter.pojo.rscloudbox;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

@Data
public class RscmAreaImageDto implements Serializable {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "﻿标识id")
	private String id;

	@ApiModelProperty(value = "﻿地区编号")
	private String areaNo;

	@ApiModelProperty(value = "﻿行列号")
	private String imageRowCol;

	@ApiModelProperty(value = "﻿卫星")
	private String imageSatelliteType;

	@ApiModelProperty(value = "﻿影像最小分辨率")
	private Double imageStartResolution;

	@ApiModelProperty(value = "﻿光谱")
	private String imageSpectrumType;

	@ApiModelProperty(value = "﻿开始时间")
	private String beginTime;

	@ApiModelProperty(value = "﻿更新时间")
	private String updateTime;

	@ApiModelProperty(value = "﻿切图范围")
	private String gemo;

	@ApiModelProperty(value = "﻿数据范围")
	private String range;

	@ApiModelProperty(value = "﻿影像数量")
	private Integer num;

	@ApiModelProperty(value = "﻿是否全覆盖")
	private Integer isCover;

	@ApiModelProperty(value = "﻿影像id")
	private String dataId;

	@ApiModelProperty(value = "﻿数据类型（0101:标准数据;0102:正射影像）")
	private String imageProductType;

	@ApiModelProperty(value = "﻿组合数据id")
	private String relationNo;

	@ApiModelProperty(value = "﻿名称")
	private String name;

	@ApiModelProperty(value = "﻿云量")
	private Double imageCloudage;

	@ApiModelProperty(value = "﻿传感器类型")
	private String sensorId;

	@ApiModelProperty(value = "﻿影像级别")
	private String productLevel;

	@ApiModelProperty(value = "﻿采集开始时间")
	private String collectStartTime;

	@ApiModelProperty(value = "﻿")
	private String filePath;

	@ApiModelProperty(value = "﻿产品序列号")
	private String productId;

	@ApiModelProperty(value = "﻿是否完成影像校正")
	private Boolean iscorrect;

	@ApiModelProperty(value = "﻿订单任务id")
	private String jobid;

	@ApiModelProperty(value = "﻿地区编码数组")
	private String areaNoArray;

	@ApiModelProperty(value = "﻿并行切割后的影像wms服务地址")
	private String imgUrl;

	@ApiModelProperty(value = "﻿影像的面积")
	private Double imageArea;

	@ApiModelProperty(value = "﻿数据记录唯一标示id")
	private String recordId;

	@ApiModelProperty(value = "﻿数据采集结束时间")
	private String collectEndTime;

	@ApiModelProperty(value = "﻿分辨率最大值")
	private Double imageEndResolution;

	@ApiModelProperty(value = "﻿标题")
	private String tip;

	@ApiModelProperty(value = "﻿坐标")
	private String srid;

	@ApiModelProperty(value = "﻿地区描述（广东省东莞市松山湖）")
	private String areaDescription;

	@ApiModelProperty(value = "﻿压缩包大小")
	private Long imageSize;

	@ApiModelProperty(value = "﻿是否自动入库【0：手动；1：自动】")
	private Integer autoTag;

	@ApiModelProperty(value = "﻿传感器类型")
	private String imageSensorType;

	@ApiModelProperty(value = "﻿数据是否已存，0否，1是")
	private Integer imageIsSave;

	@ApiModelProperty(value = "﻿分辨率[数组]")
	private String imageResolution;

	@ApiModelProperty(value = "﻿投影")
	private String imageProjection;

	@ApiModelProperty(value = "﻿覆盖大区市")
	private String imageCity;

//	public ImageDataDto toImageDataDto() {
//
//		ImageDataDto imageDataDto = BeanMapper.map(this, ImageDataDto.class);
//		imageDataDto.setThumbnailPath(getFilePath() + "/" + getName());
//		imageDataDto.setImageSpectrumTypeDisplay(getImageSpectrumType());
//		imageDataDto.setImageTakeTime(getBeginTime());
//		imageDataDto.setImageProductLevel(getProductLevel());
//		imageDataDto.setImageSceneId(getSensorId());
//		imageDataDto.setImageProductId(getProductId());
//		imageDataDto.setImageStartTime(getCollectStartTime());
//		imageDataDto.setImageEndTime(getCollectEndTime());
//		imageDataDto.setImageProductTime(getUpdateTime());
//		imageDataDto.setImageFilePath(getFilePath());
//		imageDataDto.setId(getDataId());
//		imageDataDto.setImageSensorId(getSensorId());
//
//		return imageDataDto;
//	}

//	public Map<String, Object> toImageDataMap() {
//
//		ImageDataDto imageDataDto = toImageDataDto();
//
//		Map<String, Object> imageDataMap = MapsKeyRename.reNameToUndersore(BeanMapper.map(imageDataDto, Map.class),
//				true);
//
//		return imageDataMap;
//	}

}
