package com.upyuns.platform.rs.datacenter.pojo;

import cn.hutool.core.util.StrUtil;
import com.upyuns.platform.rs.datacenter.entity.RscpImageDataTotal;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class ImageTotalInputDTO extends RscpImageDataTotal {
    //左上角经度
    private BigDecimal leftTopLon;
    //左上角维度
    private BigDecimal leftTopLat;

    //左下角经度
    private BigDecimal leftBottomLon;
    //左下角维度
    private BigDecimal leftBottomLat;

    //右下角经度
    private BigDecimal rightBottomLon;
    //右下角维度
    private BigDecimal rightBottomLat;

    //右上角经度
    private BigDecimal rightTopLon;
    //右上角维度
    private BigDecimal rightTopLat;

    //rangeJson
    private String rangeJson;

    private Long id;

    private String areaDataId;

    public void initRange(){
        String range = StrUtil.format("st_GeomFromText('MULTIPOLYGON((({} {}  ,{} {}  , {} {}  ,{} {},   {} {})))',4326)"
                , getLeftTopLon(), getLeftTopLat(), getLeftBottomLon(), getLeftBottomLat(), getRightBottomLon(), getRightBottomLat()
                , getRightTopLon(), getRightTopLat(), getLeftTopLon(), getLeftTopLat());
        setRange(range);
    }
}
