package com.github.wxiaoqi.security.admin.vo;

import lombok.Data;

import javax.persistence.Column;

/**
 * 用户信息表
 */
@Data
public class AppUserManageVo {
    /**
     * 用户id
     */
    @Column(name = "userid")
    private Integer userId;

    /**
     * 注册终端
     */
    @Column(name = "channel")
    private String channel;

    /**
     * 是否是会员：0-不是；1-会员
     */
    @Column(name = "is_member")
    private Integer isMember;

    /**
     * 真实姓名
     */
    @Column(name = "realname")
    private String realName;

    /**
     * 状态：0-正常，1-禁用
     */
    @Column(name = "status")
    private Integer status;

    /**
     * 昵称
     */
    @Column(name = "nickname")
    private String nickname;

    /**
     * 用户来源:0-自来,1-用户邀请
     */
    @Column(name = "source")
    private Integer source;

    /**
     * 省代码
     */
    @Column(name = "province_code")
    private Integer provinceCode;

    /**
     * 市代码
     */
    @Column(name = "city_code")
    private Integer cityCode;

    /**
     * 市名称
     */
    @Column(name = "city_code")
    private String cityName;

    /**
     * 用户性别
     */
    @Column(name = "sex")
    private Integer sex;

    /**
     * 用户邮箱
     */
    @Column(name = "email")
    private String email;

    /**
     * 用户名（手机号码）
     */
    @Column(name = "username")
    private String username;

    /**
     * 实名认证状态:0-未认证，1-已认证
     */
    @Column(name = "certification_status")
    private String certificationStatus;

    /**
     * 身份证号
     */
    @Column(name = "id_number")
    private String idNumber;

    /**
     * 会员等级
     */
    @Column(name = "member_level")
    private Integer memberLevel;

    /**
     * 有效期;0代表永久
     */
    @Column(name = "valid_time")
    private Long validTime;

    /**
     * 创建时间
     */
    @Column(name = "createtime")
    private Long createTime;

    /**
     * 最后的登录时间
     */
    @Column(name = "last_time")
    private Long lastTime;

    /**
     * 购买会员次数
     */
    @Column(name = "buy_count")
    private String buyCount;

    /**
     * 赠送总天数
     */
    @Column(name = "total_number")
    private String totalNumber;

    /**
     * 剩余天数
     */
    @Column(name = "rent_free_days")
    private String rentFreeDays;

    /**
     * 加入会员时间
     */
    private Long timeOfMembership;

    /**
     * 最近充值时间
     */
    @Column(name = "recent_recharge")
    private Long recentRecharge;

    /**
     * 会员名称
     */
    private String memberName;

    /**
     * 会员类型
     */
    private String memberType;

    /**
     * 头像
     */
    private String headimgurl;

    /**
     * 邀请人用户名
     */
    private String inviter;

    /**
     * 身份信息
     */
    private String positionName;

    /**
     * 上级名称
     */
    private String nameOfSuperior;

    /**
     * 上级id
     */
    private Integer parentId;

    /**
     * 上级手机号
     */
    private String superiorMobileNumber;

    /**
     * 注册时间
     */
    private Long createtime;
}
