package com.github.wxiaoqi.security.common.rest;

import cn.hutool.core.util.StrUtil;
import com.github.wxiaoqi.security.common.context.BaseContextHandler;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-15 8:48
 */
@Slf4j
public class CommonBaseController {

    @Autowired
    HttpServletResponse response;

    @Autowired
    public HttpServletRequest request;

    public HttpServletRequest getRequest() {
        return request;
    }

    public HttpServletResponse getResponse() {
        return response;
    }

    public String getCurrentUserName(){
        return BaseContextHandler.getUsername();
    }

    public String getCurrentUserId(){
        return BaseContextHandler.getUserID();
    }

    public Integer getCurrentUserIdInt(){
        return StrUtil.isBlank(getCurrentUserId()) ? null : Integer.valueOf(getCurrentUserId());
    }
}
