package com.upyuns.platform.rs.website.controller.web;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.UserAddressBiz;
import com.upyuns.platform.rs.website.dto.UserAddressDto;
import com.upyuns.platform.rs.website.entity.UserAddress;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("userAddress/web")
public class UserAddressWebController extends BaseController<UserAddressBiz,UserAddress>{

	@GetMapping(value = "getList")
	public ObjectRestResponse getList(UserAddressDto userAddressDto) {
		return baseBiz.selectList(userAddressDto);
	}

	@PostMapping(value = "addUpdate")
	public ObjectRestResponse addUpdate(@RequestBody UserAddress userAddress) {
		return baseBiz.addUpdate(userAddress);
	}

	@GetMapping(value = "getUserAddress")
	public ObjectRestResponse getUserAddress() {
		return ObjectRestResponse.succ(baseBiz.getUserAddress());
	}
}