package com.upyuns.platform.rs.website.controller.web;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.upyuns.platform.rs.website.biz.NewsInfoBiz;
import com.upyuns.platform.rs.website.dto.NewsInfoDto;
import com.upyuns.platform.rs.website.entity.NewsInfo;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("newsInfo/web")
public class NewsInfoWebController extends BaseController<NewsInfoBiz, NewsInfo> {

	@GetMapping(value = "/app/unauth/getList")
	public ObjectRestResponse getList(NewsInfoDto newsInfoDto) {
		newsInfoDto.setStatus(1);
		newsInfoDto.setSortType(1);
		return baseBiz.selectList(newsInfoDto);
	}

	@GetMapping(value = "/app/unauth/getAll")
	public ObjectRestResponse getAll(NewsInfoDto newsInfoDto) {
		return baseBiz.selectList(newsInfoDto);
	}

	@GetMapping(value = "/app/unauth/detail")
	public ObjectRestResponse detail(Integer id) {
		return ObjectRestResponse.succ(baseBiz.selectById(id));
	}
}