package com.upyuns.platform.rs.website.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.upyuns.platform.rs.website.entity.OrderEInvoice;
import com.upyuns.platform.rs.website.entity.OrderInfo;
import com.upyuns.platform.rs.website.entity.OrderItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.upyuns.platform.rs.website.entity.ShoppingCartInfo;
import com.upyuns.platform.rs.website.mapper.ShoppingCartInfoMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import tk.mybatis.mapper.entity.Example;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 购物车
 *
 * @author jiaoruizhen
 * @email jiaoruizhen@126.com
 * @date 2020-12-03 13:29:23
 */
@Service
public class ShoppingCartInfoBiz extends BaseBiz<ShoppingCartInfoMapper,ShoppingCartInfo> {

	@Autowired
	OrderInfoBiz orderInfoBiz;

	@Autowired
	OrderItemBiz orderItemBiz;

	/**
	 * 添加购物车
	 * @param shoppingCartInfo
	 * @return
	 */
	public ObjectRestResponse addUpdate(ShoppingCartInfo shoppingCartInfo) {
		if (shoppingCartInfo == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		if (shoppingCartInfo.getCartId() == null) {
			insertSelectiveRe(shoppingCartInfo);
		} else {
			ShoppingCartInfo old = selectById(shoppingCartInfo.getCartId());
			BeanUtil.copyProperties(shoppingCartInfo, old, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
			updateSelectiveByIdRe(old);
		}
		return ObjectRestResponse.succ();
	}

	/**
	 * 获取用户所有购物车商品
	 * @param userId
	 * @return
	 */
	public ObjectRestResponse getUserAllCart(Integer userId) {
		Example example = new Example(ShoppingCartInfo.class);
		example.createCriteria().andEqualTo("userId", userId).andEqualTo("isDel", 0);
		example.orderBy("updTime").desc();
		return ObjectRestResponse.succ(mapper.selectByExample(example));
	}

	/**
	 * 购物车转为订单
	 * @param ids
	 * @return
	 */
	public ObjectRestResponse convertShopCartToOrderInfo(String ids) {
		if (StringUtils.isBlank(ids)) {
			return ObjectRestResponse.paramIsEmpty();
		}
		String[] cartIds = ids.split(",");
		if (cartIds == null || ids.length() <= 0) {
			return ObjectRestResponse.createFailedResult(ResultCode.NOTEXIST_CODE, ResultCode.getMsg(ResultCode.NOTEXIST_CODE));
		}
		Example example = new Example(ShoppingCartInfo.class);
		example.createCriteria().andIn("cartId", Arrays.asList(cartIds)).andEqualTo("isDel", 0);
		List<ShoppingCartInfo> cartInfoList = mapper.selectByExample(example);
		if (cartInfoList != null && cartInfoList.size() > 0) {
			convertToOrderInfo(cartInfoList);
			return ObjectRestResponse.succ();
		}
		return ObjectRestResponse.createFailedResult(ResultCode.NOTEXIST_CODE, ResultCode.getMsg(ResultCode.NOTEXIST_CODE));
	}

	/**
	 * 购物车转订单实现
	 * @param cartInfoList
	 */
	private void convertToOrderInfo(List<ShoppingCartInfo> cartInfoList) {
		List<OrderItem> orderItemList = new ArrayList<>();
		//总金额
		double amount = cartInfoList.parallelStream().mapToDouble(shoppingCartInfo ->shoppingCartInfo.getTotalAmount().doubleValue()).sum();
		//总数量
		Integer totalNumber = cartInfoList.parallelStream().mapToInt(ShoppingCartInfo::getNumber).sum();

		OrderInfo orderInfo = new OrderInfo();
		orderInfo.setAmount(new BigDecimal(amount).setScale(2, BigDecimal.ROUND_HALF_UP));
		orderInfo.setNumber(totalNumber);

	}
}