package com.upyuns.platform.rs.datacenter.rest;

import cn.hutool.core.collection.CollUtil;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.vo.PageParam;
import com.upyuns.platform.rs.datacenter.biz.RscpImageDataTotalBiz;
import com.upyuns.platform.rs.datacenter.biz.RscpImagePriceBiz;
import com.upyuns.platform.rs.datacenter.entity.RscpImageDataTotal;
import com.upyuns.platform.rs.datacenter.entity.RscpImagePrice;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_TRUE;

@RestController
@RequestMapping("imagePrice")
public class RscpImagePriceController extends BaseController<RscpImagePriceBiz, RscpImagePrice> {

    @RequestMapping(value = "/app/unauth/all", method = RequestMethod.GET)
    public ObjectRestResponse unauthQuery() {

        List<RscpImagePrice> list = baseBiz.selectByWeekend(w -> {
            w.andEqualTo(RscpImagePrice::getStatus, SYS_TRUE);
            return w;
        }, " daily_sort asc");

        List<ImagePriceVO> imagePriceVOS = CollUtil.newArrayList();
        String key = "";
        List<String> satelliteTypes = list.parallelStream().map(RscpImagePrice::getImageSatelliteType).collect(Collectors.toList());
        for(String satelliteType : satelliteTypes) {
            List<RscpImagePrice> imagePriceList = list.parallelStream().filter(rscpImagePrice -> satelliteType.equals(rscpImagePrice.getImageSatelliteType())).collect(Collectors.toList());
            imagePriceVOS.add(new ImagePriceVO(){{
                setImageSatelliteType(satelliteType);
                setSatelliteName(imagePriceList.get(0).getSatelliteName());
                setImagePrices(imagePriceList);
            }});
        }

        return ObjectRestResponse.succ(imagePriceVOS);
    }

    @Data
    static public class ImagePriceVO {

        /** 卫星 */
        private String imageSatelliteType;

        /** 卫星全称 */
        @ApiModelProperty(value = "卫星全称")
        private String satelliteName;

        List<RscpImagePrice> imagePrices;
    }

}