package com.github.wxiaoqi.security.admin.support.aop;

import cn.hutool.core.util.ArrayUtil;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Objects;

/**
 * @author libin
 * @version 1.0
 * @description user信息组装
 * @data 2019/6/17 13:44
 */
@Aspect
@Component
@ConditionalOnClass(value = UserFeign.class)
@Slf4j
public class TokenAop {


    @Value("${auth.user.token-header:Authorization}")
    private String tokenHeader;

      @Resource
      private UserFeign userFeign;

    @Pointcut("execution(* com.upyuns.platform.rs..rest..*(..))")
    public void tokenExpress(){}

    /**
     * userFeign.userDetailByToken("");  获取app用户的信息
     * userFeign.userinfoByToken("");  获取后台用户的信息
     * @param proceedingJoinPoint
     * @return
     */
   @Around("tokenExpress()")
    public Object token(ProceedingJoinPoint proceedingJoinPoint) throws  Throwable{
       HttpServletRequest request = ((ServletRequestAttributes) (RequestContextHolder.currentRequestAttributes())).getRequest();
       String token = request.getHeader(tokenHeader);
       log.info("token【{}】",token);
       Object[] args = proceedingJoinPoint.getArgs();
       if (ArrayUtil.isEmpty(args)){
            //没有参数直接返回
           return proceedingJoinPoint.proceed();
       }
       MethodSignature methodSignature = (MethodSignature) proceedingJoinPoint.getSignature();
       Method currentMethod = methodSignature.getMethod();
       Parameter[] parameters = currentMethod.getParameters();
       for(int i =0;i<args.length;i++){
           Parameter parameter = parameters[i];
           //app用户
           if (AppUserDTO.class.equals(parameter.getType())){
                //token为空
                if (StringUtils.isEmpty(token)){
//                   return ObjectRestResponse.createFailedResult(4004,"token不能为空");
                    args[i]= new AppUserDTO();
                    break;
                }
               AppUserDTO userDTO = userFeign.userDetailByToken(token).getData();
                if (Objects.isNull(userDTO)){
                    userDTO = new AppUserDTO();
                }
                log.info("token查询app用户【{}】",userDTO);
               args[i]= userDTO;
               break;
           }
           if (UserDTO.class.equals(parameter.getType())){
               //token为空
               if (StringUtils.isEmpty(token)){
                   return ObjectRestResponse.createFailedResult(4004,"token不能为空");
               }
               args[i]=userFeign.userinfoByToken(token).getData();
               break;
           }
       }
       return proceedingJoinPoint.proceed(args);
   }
    public void setTokenHeader(String tokenHeader) {
        this.tokenHeader = tokenHeader;
    }
}
